/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.xs2a.component.logger.TppLogger;
import de.adorsys.psd2.xs2a.component.logger.TppRequestLogBuilder;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.web.PathParameterExtractor;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class SigningBasketLoggingInterceptor
extends HandlerInterceptorAdapter {
    private static final String NOT_EXIST_IN_URI = "Not exist in URI";
    private final TppService tppService;
    private final RedirectIdService redirectIdService;
    private final PathParameterExtractor pathParameterExtractor;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Map<String, String> pathVariables = this.pathParameterExtractor.extractParameters(request);
        String basketId = Optional.ofNullable(pathVariables).map(pv -> (String)pv.get("basketId")).orElse(NOT_EXIST_IN_URI);
        ((TppRequestLogBuilder)TppLogger.logRequest(request).withTpp(this.tppService.getTppInfo()).withRequestUri().withParam("Basket ID", basketId)).perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        TppLogger.logResponse(response).withTpp(this.tppService.getTppInfo()).withResponseStatus().withOptionalRedirectId(this.redirectIdService.getRedirectId()).perform();
    }

    @ConstructorProperties(value={"tppService", "redirectIdService", "pathParameterExtractor"})
    public SigningBasketLoggingInterceptor(TppService tppService, RedirectIdService redirectIdService, PathParameterExtractor pathParameterExtractor) {
        this.tppService = tppService;
        this.redirectIdService = redirectIdService;
        this.pathParameterExtractor = pathParameterExtractor;
    }
}

