/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter.holder;

import de.adorsys.psd2.consent.api.service.TppService;
import de.adorsys.psd2.validator.certificate.util.CertificateExtractorUtil;
import de.adorsys.psd2.validator.certificate.util.TppCertificateData;
import de.adorsys.psd2.xs2a.core.domain.MessageCategory;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoHolder;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppRoleValidationService;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageWriter;
import de.adorsys.psd2.xs2a.web.filter.TppErrorMessage;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aTppInfoMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.difi.certvalidator.api.CertificateValidationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QwacCertificateService {
    private static final Logger log = LoggerFactory.getLogger(QwacCertificateService.class);
    private final TppInfoHolder tppInfoHolder;
    private final RequestProviderService requestProviderService;
    private final TppRoleValidationService tppRoleValidationService;
    private final TppService tppService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final Xs2aTppInfoMapper xs2aTppInfoMapper;
    private final TppErrorMessageWriter tppErrorMessageWriter;

    public boolean isApplicable(HttpServletRequest request, HttpServletResponse response, String encodedTppQwacCert) throws IOException {
        try {
            boolean checkTppRoles;
            TppCertificateData tppCertificateData = CertificateExtractorUtil.extract((String)encodedTppQwacCert);
            if (this.isCertificateExpired(tppCertificateData.getNotAfter())) {
                this.buildCertificateExpiredErrorResponse(response);
                return false;
            }
            TppInfo tppInfo = this.xs2aTppInfoMapper.mapToTppInfo(tppCertificateData);
            String tppRolesAllowedHeader = this.requestProviderService.getTppRolesAllowedHeader();
            boolean checkTppRolesFromHeader = StringUtils.isNotBlank((CharSequence)tppRolesAllowedHeader);
            boolean checkTppRolesFromCertificate = this.aspspProfileService.isCheckTppRolesFromCertificateSupported();
            if (checkTppRolesFromHeader) {
                this.processTppRolesFromHeader(tppInfo, tppRolesAllowedHeader);
            } else if (checkTppRolesFromCertificate) {
                this.processTppRolesFromCertificate(tppInfo, tppCertificateData);
            }
            boolean bl = checkTppRoles = checkTppRolesFromHeader || checkTppRolesFromCertificate;
            if (checkTppRoles && !this.tppRoleValidationService.hasAccess(tppInfo, request)) {
                this.buildRoleInvalidErrorResponse(response, tppCertificateData);
                return false;
            }
            this.tppInfoHolder.setTppInfo(tppInfo);
            return true;
        }
        catch (CertificateValidationException e) {
            this.buildCertificateInvalidNoAccessErrorResponse(response, e);
            return false;
        }
    }

    private void buildCertificateInvalidNoAccessErrorResponse(HttpServletResponse response, CertificateValidationException e) throws IOException {
        log.info("TPP unauthorised because CertificateValidationException: {}", (Object)e.getMessage());
        this.setResponseStatusAndErrorCode(response, MessageErrorCode.CERTIFICATE_INVALID_NO_ACCESS);
    }

    private void setResponseStatusAndErrorCode(HttpServletResponse response, MessageErrorCode messageErrorCode) throws IOException {
        this.tppErrorMessageWriter.writeError(response, new TppErrorMessage(MessageCategory.ERROR, messageErrorCode, new Object[0]));
    }

    private boolean isCertificateExpired(Date date) {
        return Optional.ofNullable(date).map(d -> d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).map(d -> d.isBefore(LocalDateTime.now())).orElse(true);
    }

    private void buildRoleInvalidErrorResponse(HttpServletResponse response, TppCertificateData tppCertificateData) throws IOException {
        log.info("Access forbidden for TPP with authorisation number: [{}]", (Object)tppCertificateData.getPspAuthorisationNumber());
        this.setResponseStatusAndErrorCode(response, MessageErrorCode.ROLE_INVALID);
    }

    private void processTppRolesFromCertificate(TppInfo tppInfo, TppCertificateData tppCertificateData) {
        List<TppRole> xs2aTppRoles = tppCertificateData.getPspRoles().stream().map(TppRole::valueOf).collect(Collectors.toList());
        this.setTppRolesAndUpdateTppInfo(tppInfo, xs2aTppRoles);
    }

    private void processTppRolesFromHeader(TppInfo tppInfo, String tppRolesAllowedHeader) {
        Optional.of(tppRolesAllowedHeader).map(roles -> roles.split(",")).map(Arrays::asList).map(this.xs2aTppInfoMapper::mapToTppRoles).ifPresent(roles -> this.setTppRolesAndUpdateTppInfo(tppInfo, (List<TppRole>)roles));
    }

    private void setTppRolesAndUpdateTppInfo(TppInfo tppInfo, List<TppRole> roles) {
        if (!roles.isEmpty()) {
            tppInfo.setTppRoles(roles);
            this.tppService.updateTppInfo(tppInfo);
        }
    }

    private void buildCertificateExpiredErrorResponse(HttpServletResponse response) throws IOException {
        log.info("TPP Certificate is expired");
        this.setResponseStatusAndErrorCode(response, MessageErrorCode.CERTIFICATE_EXPIRED);
    }

    @ConstructorProperties(value={"tppInfoHolder", "requestProviderService", "tppRoleValidationService", "tppService", "aspspProfileService", "xs2aTppInfoMapper", "tppErrorMessageWriter"})
    public QwacCertificateService(TppInfoHolder tppInfoHolder, RequestProviderService requestProviderService, TppRoleValidationService tppRoleValidationService, TppService tppService, AspspProfileServiceWrapper aspspProfileService, Xs2aTppInfoMapper xs2aTppInfoMapper, TppErrorMessageWriter tppErrorMessageWriter) {
        this.tppInfoHolder = tppInfoHolder;
        this.requestProviderService = requestProviderService;
        this.tppRoleValidationService = tppRoleValidationService;
        this.tppService = tppService;
        this.aspspProfileService = aspspProfileService;
        this.xs2aTppInfoMapper = xs2aTppInfoMapper;
        this.tppErrorMessageWriter = tppErrorMessageWriter;
    }
}

