/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationServiceType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.PisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.PisPsuDataUpdateAuthorisationCheckerValidator;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationStageCheckValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.AbstractUpdatePisPsuDataValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.UpdatePisPsuDataPO;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePaymentPsuDataPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdatePisCommonPaymentPsuDataValidator
extends AbstractUpdatePisPsuDataValidator<UpdatePaymentPsuDataPO> {
    private static final Logger log = LoggerFactory.getLogger(UpdatePisCommonPaymentPsuDataValidator.class);
    private final AspspProfileServiceWrapper aspspProfileService;

    public UpdatePisCommonPaymentPsuDataValidator(PisEndpointAccessCheckerService pisEndpointAccessCheckerService, PisAuthorisationValidator pisAuthorisationValidator, PisAuthorisationStatusValidator pisAuthorisationStatusValidator, PisPsuDataUpdateAuthorisationCheckerValidator pisPsuDataUpdateAuthorisationCheckerValidator, AuthorisationStageCheckValidator authorisationStageCheckValidator, AspspProfileServiceWrapper aspspProfileService) {
        super(pisEndpointAccessCheckerService, pisAuthorisationValidator, pisAuthorisationStatusValidator, pisPsuDataUpdateAuthorisationCheckerValidator, authorisationStageCheckValidator);
        this.aspspProfileService = aspspProfileService;
    }

    @Override
    protected AuthorisationServiceType getAuthorisationServiceType() {
        return AuthorisationServiceType.PIS;
    }

    @Override
    protected ValidationResult validateTransactionStatus(UpdatePisPsuDataPO paymentObject) {
        if (paymentObject.getPisCommonPaymentResponse().getTransactionStatus() != TransactionStatus.RJCT) {
            return ValidationResult.valid();
        }
        if (this.aspspProfileService.isAuthorisationConfirmationRequestMandated() && StringUtils.isNotBlank((CharSequence)paymentObject.getUpdateRequest().getConfirmationCode())) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_400, (MessageErrorCode)MessageErrorCode.SCA_INVALID);
        }
        log.info("Authorisation ID: [{}]. Updating PIS initiation authorisation PSU Data has failed: payment has been rejected", (Object)paymentObject.getUpdateRequest().getAuthorisationId());
        return ValidationResult.invalid((ErrorType)ErrorType.PIS_403, (MessageErrorCode)MessageErrorCode.RESOURCE_EXPIRED_403);
    }
}

