/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountAccessValidator {
    public ValidationResult validate(AisConsent aisConsent, boolean withBalance) {
        if (withBalance) {
            AisConsentData aisConsentData = (AisConsentData)aisConsent.getConsentData();
            if (aisConsentData.getAllPsd2() != null) {
                return ValidationResult.valid();
            }
            if (EnumSet.of(AccountAccessType.ALL_ACCOUNTS, AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME).contains(aisConsentData.getAvailableAccountsWithBalance())) {
                return ValidationResult.valid();
            }
            if (CollectionUtils.isEmpty((Collection)aisConsent.getAccess().getBalances())) {
                return ValidationResult.invalid((ErrorType)ErrorType.AIS_401, (MessageErrorCode)MessageErrorCode.CONSENT_INVALID);
            }
        }
        return ValidationResult.valid();
    }
}

