/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.status;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.mapper.MediaTypeMapper;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aLinksMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfoMapper;
import de.adorsys.psd2.xs2a.service.payment.status.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiGetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReadCommonPaymentStatusService
implements ReadPaymentStatusService {
    private static final Logger log = LoggerFactory.getLogger(ReadCommonPaymentStatusService.class);
    private final CommonPaymentSpi commonPaymentSpi;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final MediaTypeMapper mediaTypeMapper;
    private final SpiToXs2aLinksMapper spiToXs2aLinksMapper;

    @Override
    public ReadPaymentStatusResponse readPaymentStatus(CommonPaymentData commonPaymentData, SpiContextData spiContextData, @NotNull String encryptedPaymentId, String acceptMediaType) {
        SpiAspspConsentDataProvider aspspConsentDataProvider;
        CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(commonPaymentData);
        SpiPaymentInfo request = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo(commonPayment);
        SpiResponse spiResponse = this.commonPaymentSpi.getPaymentStatusById(spiContextData, acceptMediaType, request, aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("Payment-ID [{}]. READ COMMON Payment STATUS failed. Can't get Payment status by ID at SPI level. Error msg: [{}]", (Object)commonPayment.getPaymentId(), (Object)errorHolder);
            return new ReadPaymentStatusResponse(errorHolder);
        }
        SpiGetPaymentStatusResponse payload = (SpiGetPaymentStatusResponse)spiResponse.getPayload();
        return new ReadPaymentStatusResponse(payload.getTransactionStatus(), payload.getFundsAvailable(), this.mediaTypeMapper.mapToMediaType(payload.getResponseContentType()), payload.getPaymentStatusRaw(), payload.getPsuMessage(), this.spiToXs2aLinksMapper.toXs2aLinks(payload.getLinks()), payload.getTppMessageInformation());
    }

    @ConstructorProperties(value={"commonPaymentSpi", "spiErrorMapper", "xs2aToSpiPaymentInfoMapper", "cmsToXs2aPaymentMapper", "aspspConsentDataProviderFactory", "mediaTypeMapper", "spiToXs2aLinksMapper"})
    public ReadCommonPaymentStatusService(CommonPaymentSpi commonPaymentSpi, SpiErrorMapper spiErrorMapper, Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, MediaTypeMapper mediaTypeMapper, SpiToXs2aLinksMapper spiToXs2aLinksMapper) {
        this.commonPaymentSpi = commonPaymentSpi;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aToSpiPaymentInfoMapper = xs2aToSpiPaymentInfoMapper;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.mediaTypeMapper = mediaTypeMapper;
        this.spiToXs2aLinksMapper = spiToXs2aLinksMapper;
    }
}

