/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.create;

import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.InternalPaymentStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.CreatePaymentAuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.domain.consent.StartAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisCommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationChainResponsibilityService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.PisAuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aToCmsPisCommonPaymentRequestMapper;
import de.adorsys.psd2.xs2a.service.payment.create.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.create.PisPaymentInfoCreationObject;
import de.adorsys.psd2.xs2a.service.payment.create.spi.PaymentInitiationService;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCreatePaymentService<P extends CommonPayment, S extends PaymentInitiationService<P>>
implements CreatePaymentService {
    protected final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper;
    private final Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper;
    private final S paymentInitiationService;
    private final RequestProviderService requestProviderService;
    private final LoggingContextService loggingContextService;
    private final AuthorisationChainResponsibilityService authorisationChainResponsibilityService;
    private final ScaApproachResolver scaApproachResolver;

    @Override
    public ResponseObject<PaymentInitiationResponse> createPayment(byte[] payment, PaymentInitiationParameters paymentInitiationParameters, TppInfo tppInfo) {
        PsuIdData psuIdData = paymentInitiationParameters.getPsuData();
        P paymentRequest = this.getPaymentRequest(payment, paymentInitiationParameters);
        OffsetDateTime creationTimestamp = OffsetDateTime.now();
        ((CommonPayment)paymentRequest).setCreationTimestamp(creationTimestamp);
        ((CommonPayment)paymentRequest).setInstanceId(paymentInitiationParameters.getInstanceId());
        PaymentInitiationResponse response = this.paymentInitiationService.initiatePayment(paymentRequest, paymentInitiationParameters.getPaymentProduct(), psuIdData);
        if (response.hasError()) {
            return this.buildErrorResponse(response.getErrorHolder());
        }
        String internalRequestId = this.requestProviderService.getInternalRequestIdString();
        String contentType = this.requestProviderService.getContentTypeHeader();
        PisPaymentInfo pisPaymentInfo = this.xs2aToCmsPisCommonPaymentRequestMapper.mapToPisPaymentInfo(new PisPaymentInfoCreationObject(paymentInitiationParameters, tppInfo, response, ((CommonPayment)paymentRequest).getPaymentData(), internalRequestId, creationTimestamp, contentType));
        response.setInternalRequestId(internalRequestId);
        pisPaymentInfo.setInternalPaymentStatus(InternalPaymentStatus.INITIATED);
        CreatePisCommonPaymentResponse cmsResponse = this.pisCommonPaymentService.createCommonPayment(pisPaymentInfo);
        response.setTppNotificationContentPreferred(cmsResponse.getTppNotificationContentPreferred());
        Xs2aPisCommonPayment pisCommonPayment = this.xs2aPisCommonPaymentMapper.mapToXs2aPisCommonPayment(cmsResponse, psuIdData);
        String externalPaymentId = pisCommonPayment.getPaymentId();
        if (StringUtils.isBlank((CharSequence)externalPaymentId)) {
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PAYMENT_FAILED)).build();
        }
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = response.getAspspConsentDataProvider();
        aspspConsentDataProvider.saveWith(externalPaymentId);
        response.setPaymentId(externalPaymentId);
        boolean implicitMethod = this.authorisationMethodDecider.isImplicitMethod(paymentInitiationParameters.isTppExplicitAuthorisationPreferred(), response.isMultilevelScaRequired());
        if (implicitMethod) {
            ScaStatus scaStatus = ScaStatus.STARTED;
            String authorisationId = UUID.randomUUID().toString();
            ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
            StartAuthorisationsParameters startAuthorisationsParameters = StartAuthorisationsParameters.builder().psuData(psuIdData).businessObjectId(externalPaymentId).scaStatus(scaStatus).authorisationId(authorisationId).build();
            Authorisation authorisation = new Authorisation(authorisationId, psuIdData, externalPaymentId, AuthorisationType.PIS_CREATION, scaStatus);
            PisAuthorisationProcessorRequest processorRequest = new PisAuthorisationProcessorRequest(scaApproach, scaStatus, startAuthorisationsParameters, authorisation);
            CreatePaymentAuthorisationProcessorResponse processorResponse = (CreatePaymentAuthorisationProcessorResponse)this.authorisationChainResponsibilityService.apply(processorRequest);
            this.loggingContextService.storeScaStatus(processorResponse.getScaStatus());
            Xs2aCreateAuthorisationRequest createAuthorisationRequest = Xs2aCreateAuthorisationRequest.builder().psuData(psuIdData).paymentId(externalPaymentId).authorisationId(authorisationId).scaStatus(processorResponse.getScaStatus()).scaApproach(processorResponse.getScaApproach()).build();
            PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
            Optional<Xs2aCreatePisAuthorisationResponse> consentAuthorisation = pisScaAuthorisationService.createCommonPaymentAuthorisation(createAuthorisationRequest, ((CommonPayment)paymentRequest).getPaymentType());
            if (consentAuthorisation.isEmpty()) {
                return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PAYMENT_FAILED)).build();
            }
            Xs2aCreatePisAuthorisationResponse authorisationResponse = consentAuthorisation.get();
            response.setAuthorizationId(authorisationResponse.getAuthorisationId());
            response.setScaStatus(authorisationResponse.getScaStatus());
            this.setPsuMessageAndTppMessages(response, processorResponse.getPsuMessage(), processorResponse.getTppMessages());
        }
        return ResponseObject.builder().body(response).build();
    }

    private void setPsuMessageAndTppMessages(PaymentInitiationResponse response, String psuMessage, Set<TppMessageInformation> tppMessageInformationSet) {
        if (psuMessage != null) {
            response.setPsuMessage(psuMessage);
        }
        if (tppMessageInformationSet != null) {
            response.getTppMessageInformation().addAll(tppMessageInformationSet);
        }
    }

    protected abstract P getPaymentRequest(byte[] var1, PaymentInitiationParameters var2);

    @ConstructorProperties(value={"pisCommonPaymentService", "pisScaAuthorisationServiceResolver", "authorisationMethodDecider", "xs2aPisCommonPaymentMapper", "xs2aToCmsPisCommonPaymentRequestMapper", "paymentInitiationService", "requestProviderService", "loggingContextService", "authorisationChainResponsibilityService", "scaApproachResolver"})
    public AbstractCreatePaymentService(Xs2aPisCommonPaymentService pisCommonPaymentService, PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver, AuthorisationMethodDecider authorisationMethodDecider, Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper, Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper, S paymentInitiationService, RequestProviderService requestProviderService, LoggingContextService loggingContextService, AuthorisationChainResponsibilityService authorisationChainResponsibilityService, ScaApproachResolver scaApproachResolver) {
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.pisScaAuthorisationServiceResolver = pisScaAuthorisationServiceResolver;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.xs2aPisCommonPaymentMapper = xs2aPisCommonPaymentMapper;
        this.xs2aToCmsPisCommonPaymentRequestMapper = xs2aToCmsPisCommonPaymentRequestMapper;
        this.paymentInitiationService = paymentInitiationService;
        this.requestProviderService = requestProviderService;
        this.loggingContextService = loggingContextService;
        this.authorisationChainResponsibilityService = authorisationChainResponsibilityService;
        this.scaApproachResolver = scaApproachResolver;
    }
}

