/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiTransactionListToXs2aAccountReportMapper {
    private static final Predicate<SpiTransaction> BOOKED_PREDICATE = SpiTransaction::isBookedTransaction;
    private static final Predicate<SpiTransaction> PENDING_PREDICATE = SpiTransaction::isPendingTransaction;
    private static final Predicate<SpiTransaction> INFORMATION_PREDICATE = SpiTransaction::isInformationTransaction;
    private final SpiToXs2aTransactionMapper toXs2aTransactionMapper;

    public Optional<Xs2aAccountReport> mapToXs2aAccountReport(BookingStatus bookingStatus, List<SpiTransaction> spiTransactions, byte[] rawTransactionsResponse) {
        if (ArrayUtils.isNotEmpty((byte[])rawTransactionsResponse)) {
            return Optional.of(new Xs2aAccountReport(null, null, null, rawTransactionsResponse));
        }
        if (CollectionUtils.isEmpty(spiTransactions)) {
            return Optional.empty();
        }
        List<Object> booked = Collections.emptyList();
        List<Object> pending = Collections.emptyList();
        List<Transactions> information = Collections.emptyList();
        switch (bookingStatus) {
            case INFORMATION: {
                information = this.filterTransaction(spiTransactions, INFORMATION_PREDICATE);
                break;
            }
            case BOOKED: {
                booked = this.filterTransaction(spiTransactions, BOOKED_PREDICATE);
                break;
            }
            case PENDING: {
                pending = this.filterTransaction(spiTransactions, PENDING_PREDICATE);
                break;
            }
            case BOTH: {
                booked = this.filterTransaction(spiTransactions, BOOKED_PREDICATE);
                pending = this.filterTransaction(spiTransactions, PENDING_PREDICATE);
                break;
            }
            case ALL: {
                information = this.filterTransaction(spiTransactions, INFORMATION_PREDICATE);
                booked = this.filterTransaction(spiTransactions, BOOKED_PREDICATE);
                pending = this.filterTransaction(spiTransactions, PENDING_PREDICATE);
                break;
            }
            default: {
                throw new IllegalArgumentException("This Booking Status is not supported: " + bookingStatus);
            }
        }
        return Optional.of(new Xs2aAccountReport(booked, pending, information, null));
    }

    @NotNull
    private List<Transactions> filterTransaction(List<SpiTransaction> spiTransactions, Predicate<SpiTransaction> predicate) {
        return spiTransactions.stream().filter(predicate).map(this.toXs2aTransactionMapper::mapToXs2aTransaction).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"toXs2aTransactionMapper"})
    public SpiTransactionListToXs2aAccountReportMapper(SpiToXs2aTransactionMapper toXs2aTransactionMapper) {
        this.toXs2aTransactionMapper = toXs2aTransactionMapper;
    }
}

