/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.api.service.ConsentServiceEncrypted;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.Xs2aResponse;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreatePiisConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.CmsCreateConsentResponseService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aConsentAuthorisationMapper;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aPiisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aPiisConsentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aPiisConsentService.class);
    private final ConsentServiceEncrypted consentService;
    private final Xs2aPiisConsentMapper xs2aPiisConsentMapper;
    private final AisConsentServiceEncrypted aisConsentService;
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aConsentAuthorisationMapper consentAuthorisationMapper;
    private final LoggingContextService loggingContextService;
    private final CmsCreateConsentResponseService cmsCreateConsentResponseService;

    public Xs2aResponse<Xs2aCreatePiisConsentResponse> createConsent(CreatePiisConsentRequest request, PsuIdData psuData, TppInfo tppInfo) {
        CmsConsent cmsConsent = this.xs2aPiisConsentMapper.mapToCmsConsent(request, psuData, tppInfo);
        Xs2aResponse<CmsCreateConsentResponse> createConsentResponse = this.cmsCreateConsentResponseService.getCmsCreateConsentResponse(cmsConsent);
        Xs2aCreatePiisConsentResponse xs2aCreatePiisConsentResponse = Optional.ofNullable(createConsentResponse.getPayload()).map(c -> new Xs2aCreatePiisConsentResponse(c.getConsentId(), this.xs2aPiisConsentMapper.mapToPiisConsent(c.getCmsConsent()))).orElse(null);
        return Xs2aResponse.builder().payload(xs2aCreatePiisConsentResponse).build();
    }

    public Optional<PiisConsent> getPiisConsentById(String consentId) {
        CmsResponse consentById = this.consentService.getConsentById(consentId);
        if (consentById.hasError()) {
            log.info("Get consent by id failed due to CMS problems");
            return Optional.empty();
        }
        PiisConsent piisConsent = this.xs2aPiisConsentMapper.mapToPiisConsent((CmsConsent)consentById.getPayload());
        return Optional.ofNullable(piisConsent);
    }

    public void updateConsentStatus(String consentId, ConsentStatus consentStatus) {
        CmsResponse statusUpdated;
        try {
            statusUpdated = this.consentService.updateConsentStatusById(consentId, consentStatus);
        }
        catch (WrongChecksumException e) {
            log.info("updateConsentStatus cannot be executed, checksum verification failed");
            return;
        }
        if (statusUpdated.isSuccessful() && BooleanUtils.isTrue((Boolean)((Boolean)statusUpdated.getPayload()))) {
            this.loggingContextService.storeConsentStatus(consentStatus);
        }
    }

    public CmsResponse<PiisConsent> updateAspspAccountAccess(String consentId, AccountAccess accountAccess) {
        CmsResponse response;
        CmsResponse.CmsResponseBuilder builder = CmsResponse.builder();
        try {
            response = this.aisConsentService.updateAspspAccountAccess(consentId, accountAccess);
        }
        catch (WrongChecksumException e) {
            return builder.error(CmsError.CHECKSUM_ERROR).build();
        }
        if (response.hasError()) {
            return builder.error(response.getError()).build();
        }
        return builder.payload((Object)this.xs2aPiisConsentMapper.mapToPiisConsent((CmsConsent)response.getPayload())).build();
    }

    public void updateConsentAuthorisation(ConsentAuthorisationsParameters updatePsuData) {
        Optional.ofNullable(updatePsuData).ifPresent(req -> {
            UpdateAuthorisationRequest request = this.consentAuthorisationMapper.mapToAuthorisationRequest((ConsentAuthorisationsParameters)req);
            this.authorisationService.updateAuthorisation(request, req.getAuthorizationId());
        });
    }

    public void updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) {
        try {
            this.consentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
        catch (WrongChecksumException e) {
            log.info("updateMultilevelScaRequired cannot be executed, checksum verification failed");
        }
    }

    @ConstructorProperties(value={"consentService", "xs2aPiisConsentMapper", "aisConsentService", "authorisationService", "consentAuthorisationMapper", "loggingContextService", "cmsCreateConsentResponseService"})
    public Xs2aPiisConsentService(ConsentServiceEncrypted consentService, Xs2aPiisConsentMapper xs2aPiisConsentMapper, AisConsentServiceEncrypted aisConsentService, Xs2aAuthorisationService authorisationService, Xs2aConsentAuthorisationMapper consentAuthorisationMapper, LoggingContextService loggingContextService, CmsCreateConsentResponseService cmsCreateConsentResponseService) {
        this.consentService = consentService;
        this.xs2aPiisConsentMapper = xs2aPiisConsentMapper;
        this.aisConsentService = aisConsentService;
        this.authorisationService = authorisationService;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
        this.loggingContextService = loggingContextService;
        this.cmsCreateConsentResponseService = cmsCreateConsentResponseService;
    }
}

