/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.api.service.ConsentServiceEncrypted;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.TerminateOldConsentsRequest;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.Xs2aResponse;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreateAisConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.service.CmsCreateConsentResponseService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aConsentAuthorisationMapper;
import de.adorsys.psd2.xs2a.service.profile.FrequencyPerDateCalculationService;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAisConsentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aAisConsentService.class);
    private final ConsentServiceEncrypted consentService;
    private final AisConsentServiceEncrypted aisConsentService;
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final Xs2aConsentAuthorisationMapper consentAuthorisationMapper;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;
    private final LoggingContextService loggingContextService;
    private final CmsCreateConsentResponseService cmsCreateConsentResponseService;

    public Xs2aResponse<Xs2aCreateAisConsentResponse> createConsent(CreateConsentReq request, PsuIdData psuData, TppInfo tppInfo) {
        int allowedFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(request.getFrequencyPerDay());
        CmsConsent cmsConsent = this.aisConsentMapper.mapToCmsConsent(request, psuData, tppInfo, allowedFrequencyPerDay);
        Xs2aResponse<CmsCreateConsentResponse> createConsentResponse = this.cmsCreateConsentResponseService.getCmsCreateConsentResponse(cmsConsent);
        Xs2aCreateAisConsentResponse xs2aCreateAisConsentResponse = Optional.ofNullable(createConsentResponse.getPayload()).map(c -> new Xs2aCreateAisConsentResponse(c.getConsentId(), this.aisConsentMapper.mapToAisConsent(c.getCmsConsent()), c.getCmsConsent().getTppInformation().getTppNotificationSupportedModes())).orElse(null);
        return Xs2aResponse.builder().payload(xs2aCreateAisConsentResponse).build();
    }

    public Optional<AisConsent> getAccountConsentById(String consentId) {
        CmsResponse consentById = this.consentService.getConsentById(consentId);
        if (consentById.hasError()) {
            log.info("Get consent by id failed due to CMS problems");
            return Optional.empty();
        }
        return Optional.ofNullable(this.aisConsentMapper.mapToAisConsent((CmsConsent)consentById.getPayload()));
    }

    public boolean findAndTerminateOldConsents(String newConsentId, TerminateOldConsentsRequest request) {
        CmsResponse response = this.consentService.findAndTerminateOldConsents(newConsentId, request);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public void updateConsentStatus(String consentId, ConsentStatus consentStatus) {
        CmsResponse statusUpdated;
        try {
            statusUpdated = this.consentService.updateConsentStatusById(consentId, consentStatus);
        }
        catch (WrongChecksumException e) {
            log.info("updateConsentStatus cannot be executed, checksum verification failed");
            return;
        }
        if (statusUpdated.isSuccessful() && BooleanUtils.isTrue((Boolean)((Boolean)statusUpdated.getPayload()))) {
            this.loggingContextService.storeConsentStatus(consentStatus);
        }
    }

    public void consentActionLog(String tppId, String consentId, ActionStatus actionStatus, String requestUri, boolean updateUsage, String resourceId, String transactionId) {
        try {
            this.aisConsentService.checkConsentAndSaveActionLog(new AisConsentActionRequest(tppId, consentId, actionStatus, requestUri, updateUsage, resourceId, transactionId));
        }
        catch (WrongChecksumException e) {
            log.info("consentActionLog cannot be executed, checksum verification failed");
        }
    }

    public void updateConsentAuthorisation(ConsentAuthorisationsParameters updatePsuData) {
        Optional.ofNullable(updatePsuData).ifPresent(req -> {
            UpdateAuthorisationRequest request = this.consentAuthorisationMapper.mapToAuthorisationRequest((ConsentAuthorisationsParameters)req);
            this.authorisationService.updateAuthorisation(request, req.getAuthorizationId());
        });
    }

    public CmsResponse<AisConsent> updateAspspAccountAccess(String consentId, AccountAccess accountAccess) {
        CmsResponse response;
        CmsResponse.CmsResponseBuilder builder = CmsResponse.builder();
        try {
            response = this.aisConsentService.updateAspspAccountAccess(consentId, accountAccess);
        }
        catch (WrongChecksumException e) {
            return builder.error(CmsError.CHECKSUM_ERROR).build();
        }
        if (response.hasError()) {
            return builder.error(response.getError()).build();
        }
        return builder.payload((Object)this.aisConsentMapper.mapToAisConsent((CmsConsent)response.getPayload())).build();
    }

    public Optional<List<String>> getAuthorisationSubResources(String consentId) {
        return this.authorisationService.getAuthorisationSubResources(consentId, AuthorisationType.CONSENT);
    }

    public void updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) {
        try {
            this.consentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
        catch (WrongChecksumException e) {
            log.info("updateMultilevelScaRequired cannot be executed, checksum verification failed");
        }
    }

    @ConstructorProperties(value={"consentService", "aisConsentService", "authorisationService", "aisConsentMapper", "consentAuthorisationMapper", "frequencyPerDateCalculationService", "loggingContextService", "cmsCreateConsentResponseService"})
    public Xs2aAisConsentService(ConsentServiceEncrypted consentService, AisConsentServiceEncrypted aisConsentService, Xs2aAuthorisationService authorisationService, Xs2aAisConsentMapper aisConsentMapper, Xs2aConsentAuthorisationMapper consentAuthorisationMapper, FrequencyPerDateCalculationService frequencyPerDateCalculationService, LoggingContextService loggingContextService, CmsCreateConsentResponseService cmsCreateConsentResponseService) {
        this.consentService = consentService;
        this.aisConsentService = aisConsentService;
        this.authorisationService = authorisationService;
        this.aisConsentMapper = aisConsentMapper;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
        this.loggingContextService = loggingContextService;
        this.cmsCreateConsentResponseService = cmsCreateConsentResponseService;
    }
}

