/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.api.service.ConsentServiceEncrypted;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreateAisConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aConsentAuthorisationMapper;
import de.adorsys.psd2.xs2a.service.profile.FrequencyPerDateCalculationService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAbstractConsentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aAbstractConsentService.class);
    private final ConsentServiceEncrypted consentService;
    private final AisConsentServiceEncrypted aisConsentService;
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final Xs2aConsentAuthorisationMapper consentAuthorisationMapper;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;
    private final LoggingContextService loggingContextService;

    public Optional<Xs2aCreateAisConsentResponse> createConsent(CreateConsentReq request, PsuIdData psuData, TppInfo tppInfo) {
        CmsResponse response;
        int allowedFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(request.getFrequencyPerDay());
        CmsConsent cmsConsent = this.aisConsentMapper.mapToCmsConsent(request, psuData, tppInfo, allowedFrequencyPerDay);
        try {
            response = this.consentService.createConsent(cmsConsent);
        }
        catch (WrongChecksumException e) {
            log.info("Consent cannot be created, checksum verification failed");
            return Optional.empty();
        }
        if (response.hasError()) {
            log.info("Consent cannot be created, because can't save to cms DB");
            return Optional.empty();
        }
        CmsCreateConsentResponse createConsentResponse = (CmsCreateConsentResponse)response.getPayload();
        return Optional.of(new Xs2aCreateAisConsentResponse(createConsentResponse.getConsentId(), this.aisConsentMapper.mapToAisConsent(createConsentResponse.getCmsConsent()), createConsentResponse.getCmsConsent().getTppInformation().getTppNotificationSupportedModes()));
    }

    @ConstructorProperties(value={"consentService", "aisConsentService", "authorisationService", "aisConsentMapper", "consentAuthorisationMapper", "frequencyPerDateCalculationService", "loggingContextService"})
    public Xs2aAbstractConsentService(ConsentServiceEncrypted consentService, AisConsentServiceEncrypted aisConsentService, Xs2aAuthorisationService authorisationService, Xs2aAisConsentMapper aisConsentMapper, Xs2aConsentAuthorisationMapper consentAuthorisationMapper, FrequencyPerDateCalculationService frequencyPerDateCalculationService, LoggingContextService loggingContextService) {
        this.consentService = consentService;
        this.aisConsentService = aisConsentService;
        this.authorisationService = authorisationService;
        this.aisConsentMapper = aisConsentMapper;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
        this.loggingContextService = loggingContextService;
    }
}

