/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.core.data.Consent;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiCheckConfirmationCodeRequest;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentConfirmationCodeValidationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsentAuthorisationConfirmationService<T extends Consent> {
    private static final Logger log = LoggerFactory.getLogger(ConsentAuthorisationConfirmationService.class);
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final Xs2aAuthorisationService authorisationService;
    private final SpiErrorMapper spiErrorMapper;
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;

    public ResponseObject<UpdateConsentPsuDataResponse> processAuthorisationConfirmation(ConsentAuthorisationsParameters request) {
        String authorisationId = request.getAuthorisationId();
        CmsResponse authorisationCmsResponse = this.authorisationServiceEncrypted.getAuthorisationById(authorisationId);
        if (authorisationCmsResponse.hasError()) {
            log.info("Authorisation-ID: [{}]. Update consent PSU data failed: authorisation not found by ID", (Object)request.getAuthorizationId());
            return ResponseObject.builder().fail(this.getErrorType403(), TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        Authorisation authorisation = (Authorisation)authorisationCmsResponse.getPayload();
        ScaStatus currentStatus = authorisation.getScaStatus();
        boolean processIsAllowed = currentStatus == ScaStatus.UNCONFIRMED;
        UpdateConsentPsuDataResponse response = processIsAllowed ? this.processAuthorisationConfirmationInternal(request, authorisation.getScaAuthenticationData()) : this.buildScaConfirmationCodeErrorResponse(request.getConsentId(), authorisationId, request.getPsuData());
        return Optional.ofNullable(response.getErrorHolder()).map(e -> ResponseObject.builder().fail((ErrorHolder)e).build()).orElseGet(ResponseObject.builder().body(response)::build);
    }

    private UpdateConsentPsuDataResponse processAuthorisationConfirmationInternal(ConsentAuthorisationsParameters request, String confirmationCodeFromDb) {
        return this.aspspProfileServiceWrapper.isAuthorisationConfirmationCheckByXs2a() ? this.checkAuthorisationConfirmationXs2a(request, confirmationCodeFromDb) : this.checkAuthorisationConfirmationOnSpi(request);
    }

    private UpdateConsentPsuDataResponse checkAuthorisationConfirmationXs2a(ConsentAuthorisationsParameters request, String confirmationCodeFromDb) {
        UpdateConsentPsuDataResponse response;
        String consentId = request.getConsentId();
        String authorisationId = request.getAuthorisationId();
        PsuIdData psuData = request.getPsuData();
        Optional<T> consentOptional = this.getConsentById(consentId);
        if (consentOptional.isEmpty()) {
            return this.buildConsentNotFoundErrorResponse(consentId, authorisationId, psuData);
        }
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        boolean codeCorrect = this.checkConfirmationCodeInternally(authorisationId, request.getConfirmationCode(), confirmationCodeFromDb, aspspConsentDataProvider);
        SpiResponse<SpiConsentConfirmationCodeValidationResponse> spiResponse = this.notifyConfirmationCodeValidation(this.spiContextDataProvider.provideWithPsuIdData(psuData), codeCorrect, (Consent)consentOptional.get(), aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            return this.buildConfirmationCodeSpiErrorResponse(spiResponse, consentId, authorisationId, psuData);
        }
        SpiConsentConfirmationCodeValidationResponse confirmationCodeValidationResponse = (SpiConsentConfirmationCodeValidationResponse)spiResponse.getPayload();
        UpdateConsentPsuDataResponse updateConsentPsuDataResponse = response = codeCorrect ? new UpdateConsentPsuDataResponse(confirmationCodeValidationResponse.getScaStatus(), consentId, authorisationId, psuData) : this.buildScaConfirmationCodeErrorResponse(consentId, authorisationId, psuData);
        if (spiResponse.isSuccessful()) {
            this.authorisationService.updateAuthorisationStatus(authorisationId, confirmationCodeValidationResponse.getScaStatus());
            this.updateConsentStatus(consentId, confirmationCodeValidationResponse.getConsentStatus());
            if (ConsentStatus.VALID == confirmationCodeValidationResponse.getConsentStatus()) {
                this.findAndTerminateOldConsents(consentId, (Consent)consentOptional.get());
            }
        }
        return response;
    }

    private UpdateConsentPsuDataResponse checkAuthorisationConfirmationOnSpi(ConsentAuthorisationsParameters request) {
        UpdateConsentPsuDataResponse updateConsentPsuDataResponse;
        String consentId = request.getConsentId();
        String authorisationId = request.getAuthorisationId();
        Optional<T> consentOptional = this.getConsentById(consentId);
        if (consentOptional.isEmpty()) {
            return this.buildConsentNotFoundErrorResponse(consentId, authorisationId, request.getPsuData());
        }
        SpiCheckConfirmationCodeRequest spiCheckConfirmationCodeRequest = new SpiCheckConfirmationCodeRequest(request.getConfirmationCode(), authorisationId);
        SpiResponse<SpiConsentConfirmationCodeValidationResponse> spiResponse = this.checkConfirmationCode(this.spiContextDataProvider.provideWithPsuIdData(request.getPsuData()), spiCheckConfirmationCodeRequest, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            this.updateConsentStatus(consentId, ConsentStatus.REJECTED);
            updateConsentPsuDataResponse = this.buildConfirmationCodeSpiErrorResponse(spiResponse, consentId, authorisationId, request.getPsuData());
        } else {
            SpiConsentConfirmationCodeValidationResponse confirmationCodeValidationResponse = (SpiConsentConfirmationCodeValidationResponse)spiResponse.getPayload();
            this.updateConsentStatus(consentId, confirmationCodeValidationResponse.getConsentStatus());
            updateConsentPsuDataResponse = new UpdateConsentPsuDataResponse(confirmationCodeValidationResponse.getScaStatus(), consentId, authorisationId, request.getPsuData());
            if (ConsentStatus.VALID == confirmationCodeValidationResponse.getConsentStatus()) {
                this.findAndTerminateOldConsents(consentId, (Consent)consentOptional.get());
            }
        }
        this.authorisationService.updateAuthorisationStatus(authorisationId, updateConsentPsuDataResponse.getScaStatus());
        return updateConsentPsuDataResponse;
    }

    private UpdateConsentPsuDataResponse buildScaConfirmationCodeErrorResponse(String consentId, String authorisationId, PsuIdData psuIdData) {
        ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)this.getErrorType400()).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SCA_INVALID)}).build();
        log.info("Authorisation-ID: [{}]. Update consent PSU data failed: confirmation code is wrong or has been provided more than once.", (Object)authorisationId);
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuIdData);
    }

    private UpdateConsentPsuDataResponse buildConfirmationCodeSpiErrorResponse(SpiResponse<SpiConsentConfirmationCodeValidationResponse> spiResponse, String consentId, String authorisationId, PsuIdData psuIdData) {
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, this.getServiceType());
        log.info("Authorisation-ID: [{}]. Update consent PSU data failed: error occurred at SPI.", (Object)authorisationId);
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuIdData);
    }

    private UpdateConsentPsuDataResponse buildConsentNotFoundErrorResponse(String consentId, String authorisationId, PsuIdData psuIdData) {
        ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)this.getErrorType403()).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)}).build();
        log.info("Consent-ID: [{}]. Update consent PSU data failed: consent not found by id", (Object)consentId);
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuIdData);
    }

    protected abstract void updateConsentStatus(String var1, ConsentStatus var2);

    protected abstract void findAndTerminateOldConsents(String var1, T var2);

    protected abstract SpiResponse<SpiConsentConfirmationCodeValidationResponse> notifyConfirmationCodeValidation(SpiContextData var1, boolean var2, T var3, SpiAspspConsentDataProvider var4);

    protected abstract Optional<T> getConsentById(String var1);

    protected abstract SpiResponse<SpiConsentConfirmationCodeValidationResponse> checkConfirmationCode(SpiContextData var1, SpiCheckConfirmationCodeRequest var2, SpiAspspConsentDataProvider var3);

    protected abstract boolean checkConfirmationCodeInternally(String var1, String var2, String var3, SpiAspspConsentDataProvider var4);

    protected abstract ServiceType getServiceType();

    protected abstract ErrorType getErrorType400();

    protected abstract ErrorType getErrorType403();

    @ConstructorProperties(value={"aspspProfileServiceWrapper", "spiContextDataProvider", "aspspConsentDataProviderFactory", "authorisationService", "spiErrorMapper", "authorisationServiceEncrypted"})
    public ConsentAuthorisationConfirmationService(AspspProfileServiceWrapper aspspProfileServiceWrapper, SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, Xs2aAuthorisationService authorisationService, SpiErrorMapper spiErrorMapper, AuthorisationServiceEncrypted authorisationServiceEncrypted) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.authorisationService = authorisationService;
        this.spiErrorMapper = spiErrorMapper;
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
    }
}

