/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.service.ais.AbstractBalanceService;
import de.adorsys.psd2.xs2a.service.ais.AccountServicesHolder;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.AccountMappersHolder;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetBalancesReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetAccountBalanceRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BalanceService
extends AbstractBalanceService {
    private static final Logger log = LoggerFactory.getLogger(BalanceService.class);
    private final AccountSpi accountSpi;
    private final AccountMappersHolder accountMappersHolder;
    private final AccountServicesHolder accountServicesHolder;
    private final GetBalancesReportValidator getBalancesReportValidator;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    public BalanceService(AccountServicesHolder accountServicesHolder, Xs2aEventService xs2aEventService, LoggingContextService loggingContextService, AccountSpi accountSpi, AccountMappersHolder accountMappersHolder, GetBalancesReportValidator getBalancesReportValidator, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        super(accountServicesHolder, xs2aEventService, loggingContextService);
        this.accountServicesHolder = accountServicesHolder;
        this.accountSpi = accountSpi;
        this.accountMappersHolder = accountMappersHolder;
        this.getBalancesReportValidator = getBalancesReportValidator;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }

    @Override
    protected EventType getEventType() {
        return EventType.READ_BALANCE_REQUEST_RECEIVED;
    }

    @Override
    protected ValidationResult getValidationResultForCommonAccountBalanceRequest(String accountId, String requestUri, AisConsent accountConsent) {
        return this.getBalancesReportValidator.validate(new GetAccountBalanceRequestObject(accountConsent, accountId, requestUri));
    }

    @Override
    protected SpiResponse<List<SpiAccountBalance>> getSpiResponse(AisConsent aisConsent, String consentId, String accountId) {
        AccountAccess access = aisConsent.getAspspAccountAccesses();
        SpiAccountReference requestedAccountReference = this.accountServicesHolder.findAccountReference(access.getBalances(), accountId);
        return this.accountSpi.requestBalancesForAccount(this.accountServicesHolder.getSpiContextData(), requestedAccountReference, this.accountMappersHolder.mapToSpiAccountConsent(aisConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    @Override
    protected ResponseObject<Xs2aBalancesReport> checkSpiResponse(String consentId, String accountId, SpiResponse<List<SpiAccountBalance>> spiResponse) {
        log.info("Account-ID [{}], Consent-ID: [{}]. Get balances report failed: error on SPI level", (Object)accountId, (Object)consentId);
        return ResponseObject.builder().fail(new MessageError(this.accountMappersHolder.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
    }

    @Override
    protected ResponseObject<Xs2aBalancesReport> getXs2aBalancesReportResponseObject(AisConsent accountConsent, String accountId, String consentId, String requestUri, List<SpiAccountBalance> payload) {
        AccountAccess access = accountConsent.getAspspAccountAccesses();
        List balances = access.getBalances();
        if (this.hasNoAccessToSource(balances)) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_INVALID)).build();
        }
        SpiAccountReference requestedAccountReference = this.accountServicesHolder.findAccountReference(balances, accountId);
        Xs2aBalancesReport balancesReport = this.accountMappersHolder.mapToXs2aBalancesReportSpi(requestedAccountReference, payload);
        ResponseObject<Xs2aBalancesReport> response = ResponseObject.builder().body(balancesReport).build();
        this.accountServicesHolder.consentActionLog(this.accountServicesHolder.getTppId(), consentId, this.accountServicesHolder.createActionStatus(false, TypeAccess.BALANCE, response), requestUri, this.accountServicesHolder.needsToUpdateUsage(accountConsent), accountId, null);
        return response;
    }

    private boolean hasNoAccessToSource(List<AccountReference> references) {
        return references.stream().allMatch(AccountReference::isNotIbanAccount);
    }
}

