/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScaApproachResolver {
    private static final Logger log = LoggerFactory.getLogger(ScaApproachResolver.class);
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final AspspProfileService aspspProfileService;
    private final RequestProviderService requestProviderService;

    public ScaApproachResolver(Xs2aAuthorisationService xs2aAuthorisationService, AspspProfileService aspspProfileService, RequestProviderService requestProviderService) {
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
    }

    public ScaApproach resolveScaApproach() {
        Optional<Boolean> tppRedirectPreferredOptional = this.requestProviderService.resolveTppRedirectPreferred();
        Optional<Boolean> tppDecoupledPreferredOptional = this.requestProviderService.resolveTppDecoupledPreferred();
        return this.resolveHeaders(tppRedirectPreferredOptional, tppDecoupledPreferredOptional);
    }

    private ScaApproach resolveHeaders(Optional<Boolean> tppRedirectPreferredOptional, Optional<Boolean> tppDecoupledPreferredOptional) {
        List scaApproaches = this.aspspProfileService.getScaApproaches(this.requestProviderService.getInstanceId());
        if (tppRedirectPreferredOptional.isEmpty() && tppDecoupledPreferredOptional.isEmpty()) {
            return this.getFirst(scaApproaches);
        }
        boolean tppRedirectPreferred = tppRedirectPreferredOptional.orElse(false);
        boolean tppDecoupledPreferred = tppDecoupledPreferredOptional.orElse(false);
        if (tppRedirectPreferred && tppDecoupledPreferred) {
            return this.getScaApproachByPreferredHeadersTrue(scaApproaches);
        }
        if (tppRedirectPreferred && scaApproaches.contains(ScaApproach.REDIRECT)) {
            return ScaApproach.REDIRECT;
        }
        if (tppDecoupledPreferred && scaApproaches.contains(ScaApproach.DECOUPLED)) {
            return ScaApproach.DECOUPLED;
        }
        return this.getScaApproachByPreferredHeadersFalse(tppRedirectPreferredOptional, tppDecoupledPreferredOptional, scaApproaches);
    }

    private ScaApproach getScaApproachByPreferredHeadersFalse(Optional<Boolean> tppRedirectPreferredOptional, Optional<Boolean> tppDecoupledPreferredOptional, List<ScaApproach> scaApproaches) {
        boolean bothFalse;
        boolean notRedirect;
        ScaApproach firstScaApproach = this.getFirst(scaApproaches);
        boolean tppDecoupledPreferred = tppDecoupledPreferredOptional.orElse(false);
        boolean notDecoupled = tppRedirectPreferredOptional.isEmpty() && !tppDecoupledPreferred && ScaApproach.DECOUPLED == firstScaApproach && scaApproaches.size() > 1;
        boolean tppRedirectPreferred = tppRedirectPreferredOptional.orElse(false);
        boolean bl = notRedirect = tppDecoupledPreferredOptional.isEmpty() && !tppRedirectPreferred && ScaApproach.REDIRECT == firstScaApproach && scaApproaches.size() > 1;
        if (notDecoupled || notRedirect) {
            return this.getSecond(scaApproaches);
        }
        boolean bothNotEmpty = tppRedirectPreferredOptional.isPresent() && tppDecoupledPreferredOptional.isPresent();
        boolean bl2 = bothFalse = !tppDecoupledPreferred && !tppRedirectPreferred;
        if (bothNotEmpty && bothFalse && scaApproaches.contains(ScaApproach.EMBEDDED)) {
            return ScaApproach.EMBEDDED;
        }
        return firstScaApproach;
    }

    private ScaApproach getScaApproachByPreferredHeadersTrue(List<ScaApproach> scaApproaches) {
        if (this.getFirst(scaApproaches) != ScaApproach.EMBEDDED || scaApproaches.size() == 1) {
            return this.getFirst(scaApproaches);
        }
        return this.getSecond(scaApproaches);
    }

    @NotNull
    public ScaApproach getScaApproach(@NotNull String authorisationId) {
        return this.resolveScaApproach(authorisationId);
    }

    @NotNull
    private ScaApproach resolveScaApproach(@NotNull String authorisationId) {
        Optional<AuthorisationScaApproachResponse> scaApproachResponse = this.xs2aAuthorisationService.getAuthorisationScaApproach(authorisationId);
        if (scaApproachResponse.isEmpty()) {
            log.info("Couldn't retrieve SCA approach from the authorisation with id: {}", (Object)authorisationId);
            throw new IllegalArgumentException("Wrong authorisation id: " + authorisationId);
        }
        return scaApproachResponse.get().getScaApproach();
    }

    private ScaApproach getFirst(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(0);
    }

    private ScaApproach getSecond(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(1);
    }
}

