/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.RequestData;
import de.adorsys.psd2.xs2a.service.InternalRequestIdService;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"!mock-qwac"})
@Service
public class RequestProviderService {
    private static final String TPP_REDIRECT_PREFERRED_HEADER = "tpp-redirect-preferred";
    private static final String TPP_DECOUPLED_PREFERRED_HEADER = "tpp-decoupled-preferred";
    private static final String X_REQUEST_ID_HEADER = "x-request-id";
    private static final String PSU_ID_HEADER = "psu-id";
    private static final String PSU_ID_TYPE_HEADER = "psu-id-type";
    private static final String PSU_CORPORATE_ID_HEADER = "psu-corporate-id";
    private static final String PSU_CORPORATE_ID_TYPE_HEADER = "psu-corporate-id-type";
    private static final String PSU_IP_ADDRESS = "psu-ip-address";
    private static final String TPP_ROLES_ALLOWED_HEADER = "tpp-roles-allowed";
    private static final String ACCEPT_HEADER = "accept";
    static final String TPP_QWAC_CERTIFICATE_HEADER = "tpp-qwac-certificate";
    private static final String TPP_BRAND_LOGGING_INFORMATION = "tpp-brand-logging-information";
    private static final String TPP_REJECTION_NO_FUNDS_PREFERRED = "tpp-rejection-nofunds-preferred";
    static final String INSTANCE_ID = "instance-id";
    private final HttpServletRequest httpServletRequest;
    private final InternalRequestIdService internalRequestIdService;

    public Optional<Boolean> resolveTppRedirectPreferred() {
        String header = this.getHeader(TPP_REDIRECT_PREFERRED_HEADER);
        if (header == null) {
            return Optional.empty();
        }
        return Optional.of(Boolean.valueOf(header));
    }

    public Optional<Boolean> resolveTppDecoupledPreferred() {
        String header = this.getHeader(TPP_DECOUPLED_PREFERRED_HEADER);
        if (header == null) {
            return Optional.empty();
        }
        return Optional.of(Boolean.valueOf(header));
    }

    public RequestData getRequestData() {
        String uri = this.httpServletRequest.getRequestURI();
        UUID internalRequestId = this.getInternalRequestId();
        UUID requestId = UUID.fromString(this.getHeader(X_REQUEST_ID_HEADER));
        String ip = this.httpServletRequest.getRemoteAddr();
        Map<String, String> headers = this.getRequestHeaders(this.httpServletRequest);
        PsuIdData psuIdData = this.getPsuIdData();
        return new RequestData(uri, internalRequestId, requestId, ip, headers, psuIdData);
    }

    public PsuIdData getPsuIdData() {
        return new PsuIdData(this.getHeader(PSU_ID_HEADER), this.getHeader(PSU_ID_TYPE_HEADER), this.getHeader(PSU_CORPORATE_ID_HEADER), this.getHeader(PSU_CORPORATE_ID_TYPE_HEADER), this.getHeader(PSU_IP_ADDRESS));
    }

    @NotNull
    public UUID getInternalRequestId() {
        return this.internalRequestIdService.getInternalRequestId();
    }

    @Nullable
    public String getInstanceId() {
        return this.getHeader(INSTANCE_ID);
    }

    public String getInternalRequestIdString() {
        return this.getInternalRequestId().toString();
    }

    public UUID getRequestId() {
        return this.getRequestData().getRequestId();
    }

    public String getRequestIdString() {
        return this.getHeader(X_REQUEST_ID_HEADER);
    }

    public boolean isRequestFromPsu() {
        return StringUtils.isNotBlank((CharSequence)this.getPsuIpAddress());
    }

    public boolean isRequestFromTPP() {
        return !this.isRequestFromPsu();
    }

    public String getPsuIpAddress() {
        return this.getHeader(PSU_IP_ADDRESS);
    }

    public String getTppRedirectURI() {
        return this.getHeader("tpp-redirect-uri");
    }

    public String getTppNokRedirectURI() {
        return this.getHeader("tpp-nok-redirect-uri");
    }

    public String getOAuth2Token() {
        String headerValue = this.getHeader("Authorization");
        return StringUtils.isEmpty((CharSequence)headerValue) ? null : headerValue.replace("Bearer ", "");
    }

    public String getTppRolesAllowedHeader() {
        return this.getHeader(TPP_ROLES_ALLOWED_HEADER);
    }

    @NotNull
    public String getAcceptHeader() {
        String acceptHeader = this.getHeader(ACCEPT_HEADER);
        if (acceptHeader == null) {
            return "*/*";
        }
        return acceptHeader;
    }

    public String getContentTypeHeader() {
        return this.getHeader("Content-Type");
    }

    public String getEncodedTppQwacCert() {
        return this.getHeader(TPP_QWAC_CERTIFICATE_HEADER);
    }

    public String getTppBrandLoggingInformationHeader() {
        return this.getHeader(TPP_BRAND_LOGGING_INFORMATION);
    }

    public Boolean getTppRejectionNoFundsPreferred() {
        return Optional.ofNullable(this.getHeader(TPP_REJECTION_NO_FUNDS_PREFERRED)).map(BooleanUtils::toBoolean).orElse(null);
    }

    private String getHeader(String headerName) {
        return this.httpServletRequest.getHeader(headerName);
    }

    private Map<String, String> getRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }

    @ConstructorProperties(value={"httpServletRequest", "internalRequestIdService"})
    public RequestProviderService(HttpServletRequest httpServletRequest, InternalRequestIdService internalRequestIdService) {
        this.httpServletRequest = httpServletRequest;
        this.internalRequestIdService = internalRequestIdService;
    }
}

