/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.Xs2aResponse;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreatePiisConsentResponse;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConfirmationOfFundsConsentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.StartAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aConfirmationOfFundsResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.ConfirmationOfFundsConsentValidationService;
import de.adorsys.psd2.xs2a.service.PiisConsentAuthorisationService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationChainResponsibilityService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.ConsentAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.PiisAuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPiisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aLinksMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPiisConsentMapper;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.piis.CreatePiisConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.dto.CreatePiisConsentRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiatePiisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.piis.SpiPiisConsent;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PiisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentService {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentService.class);
    private final Xs2aPiisConsentService xs2aPiisConsentService;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final RequestProviderService requestProviderService;
    private final PiisConsentSpi piisConsentSpi;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aToSpiPiisConsentMapper xs2aToSpiPiisConsentMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    private final CreatePiisConsentValidator createPiisConsentValidator;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final PiisScaAuthorisationServiceResolver piisScaAuthorisationServiceResolver;
    private final ConfirmationOfFundsConsentValidationService confirmationOfFundsConsentValidationService;
    private final PiisConsentAuthorisationService piisConsentAuthorisationService;
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final SpiToXs2aLinksMapper spiToXs2aLinksMapper;
    private final ScaApproachResolver scaApproachResolver;
    private final AuthorisationChainResponsibilityService authorisationChainResponsibilityService;
    private final LoggingContextService loggingContextService;

    public ResponseObject<Xs2aConfirmationOfFundsResponse> createPiisConsentWithResponse(CreatePiisConsentRequest request, PsuIdData psuData, boolean explicitPreferred) {
        this.xs2aEventService.recordTppRequest(EventType.CREATE_PIIS_CONSENT_REQUEST_RECEIVED, request);
        ValidationResult validationResult = this.createPiisConsentValidator.validate(new CreatePiisConsentRequestObject(request, psuData));
        if (validationResult.isNotValid()) {
            log.info("Create funds confirmation consent with response - validation failed: {}", (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        TppInfo tppInfo = this.tppService.getTppInfo();
        Xs2aResponse<Xs2aCreatePiisConsentResponse> xs2aResponse = this.xs2aPiisConsentService.createConsent(request, psuData, tppInfo);
        if (xs2aResponse.hasError()) {
            return this.resolveConsentCreationError(xs2aResponse.getErrors().stream().map(TppMessage::getErrorCode).collect(Collectors.toList()));
        }
        Xs2aCreatePiisConsentResponse xs2aCreatePiisConsentResponse = xs2aResponse.getPayload();
        PiisConsent piisConsent = xs2aCreatePiisConsentResponse.getPiisConsent();
        String encryptedConsentId = xs2aCreatePiisConsentResponse.getConsentId();
        SpiContextData contextData = this.spiContextDataProvider.provide(psuData, tppInfo);
        SpiPiisConsent spiPiisConsent = this.xs2aToSpiPiisConsentMapper.mapToSpiPiisConsent(piisConsent);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiInitiatePiisConsentResponseSpiResponse = this.piisConsentSpi.initiatePiisConsent(contextData, spiPiisConsent, (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        aspspConsentDataProvider.saveWith(encryptedConsentId);
        if (spiInitiatePiisConsentResponseSpiResponse.hasError()) {
            this.xs2aPiisConsentService.updateConsentStatus(encryptedConsentId, ConsentStatus.REJECTED);
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiInitiatePiisConsentResponseSpiResponse, ServiceType.PIIS);
            log.info("Consent-ID: [{}]. Create piis consent  with response failed. Consent rejected. Couldn't initiate PIIS consent at SPI level: {}", (Object)encryptedConsentId, (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        SpiInitiatePiisConsentResponse spiInitiatePiisConsentResponse = (SpiInitiatePiisConsentResponse)spiInitiatePiisConsentResponseSpiResponse.getPayload();
        SpiAccountReference spiAccountReference = spiInitiatePiisConsentResponse.getSpiAccountReference();
        AccountAccess accountAccess = new AccountAccess(Collections.singletonList(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(spiAccountReference)), Collections.emptyList(), Collections.emptyList(), null);
        this.accountReferenceUpdater.rewriteAccountAccess(encryptedConsentId, accountAccess, ConsentType.PIIS_TPP);
        ConsentStatus consentStatus = piisConsent.getConsentStatus();
        boolean multilevelScaRequired = spiInitiatePiisConsentResponse.isMultilevelScaRequired();
        this.updateMultilevelSca(encryptedConsentId, multilevelScaRequired);
        Xs2aConfirmationOfFundsResponse xs2aConfirmationOfFundsResponse = new Xs2aConfirmationOfFundsResponse(consentStatus.getValue(), encryptedConsentId, multilevelScaRequired, this.requestProviderService.getInternalRequestIdString());
        xs2aConfirmationOfFundsResponse.setPsuMessage(spiInitiatePiisConsentResponse.getPsuMessage());
        if (this.authorisationMethodDecider.isImplicitMethod(explicitPreferred, multilevelScaRequired)) {
            this.proceedImplicitCaseForCreateConsent(xs2aConfirmationOfFundsResponse, psuData, encryptedConsentId);
        }
        return ResponseObject.builder().body(xs2aConfirmationOfFundsResponse).build();
    }

    private ResponseObject<Xs2aConfirmationOfFundsResponse> resolveConsentCreationError(List<MessageErrorCode> errors) {
        if (errors.contains(MessageErrorCode.PSU_CREDENTIALS_INVALID)) {
            return ResponseObject.builder().fail(ErrorType.PIIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PSU_CREDENTIALS_INVALID)).build();
        }
        return ResponseObject.builder().fail(ErrorType.PIIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_400)).build();
    }

    public ResponseObject<PiisConsent> getPiisConsentById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_PIIS_CONSENT_REQUEST_RECEIVED);
        Optional<PiisConsent> piisConsentById = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentById.isEmpty()) {
            log.info("Consent-ID: [{}]. Get PIIS consent failed: initial consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        PiisConsent piisConsent = piisConsentById.get();
        SpiResponse<SpiConsentStatusResponse> spiResponse = this.getConsentStatusFromSpi(piisConsent, consentId);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIIS);
            log.info("Get PIIS consent status failed: Couldn't get PIIS consent status at SPI level: {}", (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        ConsentStatus consentStatus = ((SpiConsentStatusResponse)spiResponse.getPayload()).getConsentStatus();
        piisConsent.setConsentStatus(consentStatus);
        this.xs2aPiisConsentService.updateConsentStatus(consentId, consentStatus);
        return ResponseObject.builder().body(piisConsent).build();
    }

    public ResponseObject<ConsentStatusResponse> getPiisConsentStatusById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_PIIS_CONSENT_STATUS_REQUEST_RECEIVED);
        ResponseObject.ResponseBuilder<ConsentStatusResponse> responseBuilder = ResponseObject.builder();
        Optional<PiisConsent> piisConsentById = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentById.isEmpty()) {
            log.info("Consent-ID: [{}]. Get PIIS consent failed: initial consent not found by id", (Object)consentId);
            return responseBuilder.fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        PiisConsent piisConsent = piisConsentById.get();
        SpiResponse<SpiConsentStatusResponse> spiResponse = this.getConsentStatusFromSpi(piisConsent, consentId);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIIS);
            log.info("Get PIIS consent status failed: Couldn't get PIIS consent status at SPI level: {}", (Object)errorHolder);
            return responseBuilder.fail(new MessageError(errorHolder)).build();
        }
        SpiConsentStatusResponse spiPayload = (SpiConsentStatusResponse)spiResponse.getPayload();
        ConsentStatus consentStatus = spiPayload.getConsentStatus();
        this.xs2aPiisConsentService.updateConsentStatus(consentId, consentStatus);
        return responseBuilder.body(new ConsentStatusResponse(consentStatus, spiPayload.getPsuMessage())).build();
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        return this.piisConsentAuthorisationService.getConsentInitiationAuthorisations(consentId);
    }

    public ResponseObject<Xs2aScaStatusResponse> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        SpiPiisConsent spiPiisConsent;
        ResponseObject<ConfirmationOfFundsConsentScaStatus> cmsConsentScaStatusResponse = this.piisConsentAuthorisationService.getConsentAuthorisationScaStatus(consentId, authorisationId);
        if (cmsConsentScaStatusResponse.hasError()) {
            return ResponseObject.builder().fail(cmsConsentScaStatusResponse.getError()).build();
        }
        SpiContextData contextData = this.getSpiContextData();
        SpiAspspConsentDataProvider spiAspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        ScaStatus scaStatus = cmsConsentScaStatusResponse.getBody().getScaStatus();
        SpiResponse spiScaStatusResponse = this.piisConsentSpi.getScaStatus(scaStatus, contextData, authorisationId, (Object)(spiPiisConsent = this.xs2aToSpiPiisConsentMapper.mapToSpiPiisConsent(cmsConsentScaStatusResponse.getBody().getPiisConsent())), spiAspspConsentDataProvider);
        if (spiScaStatusResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiScaStatusResponse, ServiceType.PIIS);
            log.info("Authorisation-ID [{}], PIIS consent-ID [{}]. Get SCA status failed.", (Object)authorisationId, (Object)consentId);
            return ResponseObject.builder().fail(errorHolder).build();
        }
        SpiScaStatusResponse spiScaInformationPayload = (SpiScaStatusResponse)spiScaStatusResponse.getPayload();
        if (scaStatus.isNotFinalisedStatus() && scaStatus != spiScaInformationPayload.getScaStatus()) {
            scaStatus = spiScaInformationPayload.getScaStatus();
            this.xs2aAuthorisationService.updateAuthorisationStatus(authorisationId, scaStatus);
            log.info("Authorisation-ID [{}], PIIS consent-ID [{}]. SCA status was changed to [{}] from SPI.", new Object[]{authorisationId, consentId, scaStatus});
        }
        return ResponseObject.builder().body(new Xs2aScaStatusResponse(scaStatus, null, spiScaInformationPayload.getPsuMessage(), this.spiToXs2aLinksMapper.toXs2aLinks(spiScaInformationPayload.getLinks()), spiScaInformationPayload.getTppMessageInformation())).build();
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.DELETE_PIIS_CONSENT_REQUEST_RECEIVED);
        ResponseObject.ResponseBuilder responseBuilder = ResponseObject.builder();
        Optional<PiisConsent> piisConsentById = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentById.isEmpty()) {
            log.info("Consent-ID: [{}]. Delete PIIS consent failed: initial consent not found by id", (Object)consentId);
            return responseBuilder.fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        PiisConsent piisConsent = piisConsentById.get();
        ValidationResult validationResult = this.confirmationOfFundsConsentValidationService.validateConsentOnDelete(piisConsent);
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}]. Delete Confirmation of Funds Consent - validation failed: {}", (Object)piisConsent.getId(), (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiContextData contextData = this.getSpiContextData();
        SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        SpiPiisConsent spiPiisConsent = this.xs2aToSpiPiisConsentMapper.mapToSpiPiisConsent(piisConsent);
        SpiResponse revokePiisConsentResponse = this.piisConsentSpi.revokePiisConsent(contextData, spiPiisConsent, aspspDataProvider);
        if (revokePiisConsentResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(revokePiisConsentResponse, ServiceType.PIIS);
            log.info("Consent-ID: [{}]. Delete Confirmation of Funds Consent failed: Couldn't revoke PIIS consent at SPI level: {}", (Object)piisConsent.getId(), (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        ConsentStatus newConsentStatus = piisConsent.getConsentStatus() == ConsentStatus.RECEIVED ? ConsentStatus.REJECTED : ConsentStatus.TERMINATED_BY_TPP;
        this.xs2aPiisConsentService.updateConsentStatus(consentId, newConsentStatus);
        return ResponseObject.builder().build();
    }

    public ResponseObject<AuthorisationResponse> createPiisAuthorisation(PsuIdData psuData, String consentId, String password) {
        return this.piisConsentAuthorisationService.createPiisAuthorisation(psuData, consentId, password);
    }

    private void updateMultilevelSca(String consentId, boolean multilevelScaRequired) {
        if (multilevelScaRequired) {
            this.xs2aPiisConsentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(ConsentAuthorisationsParameters updatePsuData) {
        return this.piisConsentAuthorisationService.updateConsentPsuData(updatePsuData);
    }

    private SpiContextData getSpiContextData() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("Corresponding PSU-ID {} was provided from request.", (Object)psuIdData);
        return this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
    }

    private SpiResponse<SpiConsentStatusResponse> getConsentStatusFromSpi(PiisConsent piisConsent, String consentId) {
        SpiPiisConsent spiPiisConsent = this.xs2aToSpiPiisConsentMapper.mapToSpiPiisConsent(piisConsent);
        SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        return this.piisConsentSpi.getConsentStatus(this.spiContextDataProvider.provide(), spiPiisConsent, aspspDataProvider);
    }

    private void proceedImplicitCaseForCreateConsent(Xs2aConfirmationOfFundsResponse createConsentResponse, PsuIdData psuIdData, String consentId) {
        ScaStatus scaStatus = ScaStatus.STARTED;
        String authorisationId = UUID.randomUUID().toString();
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        StartAuthorisationsParameters startAuthorisationsParameters = StartAuthorisationsParameters.builder().psuData(psuIdData).businessObjectId(consentId).scaStatus(scaStatus).authorisationId(authorisationId).build();
        Authorisation authorisation = new Authorisation(authorisationId, psuIdData, consentId, AuthorisationType.CONSENT, scaStatus);
        PiisAuthorisationProcessorRequest processorRequest = new PiisAuthorisationProcessorRequest(scaApproach, scaStatus, startAuthorisationsParameters, authorisation);
        CreateConsentAuthorisationProcessorResponse processorResponse = (CreateConsentAuthorisationProcessorResponse)this.authorisationChainResponsibilityService.apply(processorRequest);
        this.loggingContextService.storeScaStatus(processorResponse.getScaStatus());
        Xs2aCreateAuthorisationRequest createAuthorisationRequest = Xs2aCreateAuthorisationRequest.builder().psuData(psuIdData).consentId(consentId).authorisationId(authorisationId).scaStatus(processorResponse.getScaStatus()).scaApproach(processorResponse.getScaApproach()).build();
        ConsentAuthorizationService service = (ConsentAuthorizationService)this.piisScaAuthorisationServiceResolver.getService();
        Optional<CreateConsentAuthorizationResponse> consentAuthorizationResponse = service.createConsentAuthorization(createAuthorisationRequest);
        if (consentAuthorizationResponse.isPresent()) {
            CreateConsentAuthorizationResponse createConsentAuthorizationResponse = consentAuthorizationResponse.get();
            createConsentResponse.setAuthorizationId(createConsentAuthorizationResponse.getAuthorisationId());
            createConsentResponse.setScaStatus(createConsentAuthorizationResponse.getScaStatus());
            createConsentResponse.setScaApproach(createConsentAuthorizationResponse.getScaApproach());
            this.setPsuMessageAndTppMessages(createConsentResponse, processorResponse.getPsuMessage(), processorResponse.getTppMessages());
            this.loggingContextService.storeScaStatus(createConsentAuthorizationResponse.getScaStatus());
        }
    }

    private void setPsuMessageAndTppMessages(Xs2aConfirmationOfFundsResponse response, String psuMessage, Set<TppMessageInformation> tppMessageInformationSet) {
        if (psuMessage != null) {
            response.setPsuMessage(psuMessage);
        }
        if (tppMessageInformationSet != null) {
            response.getTppMessageInformation().addAll(tppMessageInformationSet);
        }
    }

    @ConstructorProperties(value={"xs2aPiisConsentService", "tppService", "xs2aEventService", "requestProviderService", "piisConsentSpi", "spiContextDataProvider", "xs2aToSpiPiisConsentMapper", "aspspConsentDataProviderFactory", "spiErrorMapper", "accountReferenceUpdater", "spiToXs2aAccountReferenceMapper", "createPiisConsentValidator", "authorisationMethodDecider", "piisScaAuthorisationServiceResolver", "confirmationOfFundsConsentValidationService", "piisConsentAuthorisationService", "xs2aAuthorisationService", "spiToXs2aLinksMapper", "scaApproachResolver", "authorisationChainResponsibilityService", "loggingContextService"})
    public PiisConsentService(Xs2aPiisConsentService xs2aPiisConsentService, TppService tppService, Xs2aEventService xs2aEventService, RequestProviderService requestProviderService, PiisConsentSpi piisConsentSpi, SpiContextDataProvider spiContextDataProvider, Xs2aToSpiPiisConsentMapper xs2aToSpiPiisConsentMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper, CreatePiisConsentValidator createPiisConsentValidator, AuthorisationMethodDecider authorisationMethodDecider, PiisScaAuthorisationServiceResolver piisScaAuthorisationServiceResolver, ConfirmationOfFundsConsentValidationService confirmationOfFundsConsentValidationService, PiisConsentAuthorisationService piisConsentAuthorisationService, Xs2aAuthorisationService xs2aAuthorisationService, SpiToXs2aLinksMapper spiToXs2aLinksMapper, ScaApproachResolver scaApproachResolver, AuthorisationChainResponsibilityService authorisationChainResponsibilityService, LoggingContextService loggingContextService) {
        this.xs2aPiisConsentService = xs2aPiisConsentService;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.requestProviderService = requestProviderService;
        this.piisConsentSpi = piisConsentSpi;
        this.spiContextDataProvider = spiContextDataProvider;
        this.xs2aToSpiPiisConsentMapper = xs2aToSpiPiisConsentMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiToXs2aAccountReferenceMapper = spiToXs2aAccountReferenceMapper;
        this.createPiisConsentValidator = createPiisConsentValidator;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.piisScaAuthorisationServiceResolver = piisScaAuthorisationServiceResolver;
        this.confirmationOfFundsConsentValidationService = confirmationOfFundsConsentValidationService;
        this.piisConsentAuthorisationService = piisConsentAuthorisationService;
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.spiToXs2aLinksMapper = spiToXs2aLinksMapper;
        this.scaApproachResolver = scaApproachResolver;
        this.authorisationChainResponsibilityService = authorisationChainResponsibilityService;
        this.loggingContextService = loggingContextService;
    }
}

