/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.profile.NotificationSupportedMode;
import de.adorsys.psd2.xs2a.core.tpp.TppNotificationData;
import de.adorsys.psd2.xs2a.domain.NotificationModeResponseHeaders;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NotificationSupportedModeService {
    private static final Logger log = LoggerFactory.getLogger(NotificationSupportedModeService.class);
    private static final String HEADER_PREFIX = "status=";
    private static final String MODES_SEPARATOR = ",";
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    public NotificationModeResponseHeaders resolveNotificationHeaders(List<NotificationSupportedMode> usedModes) {
        List<NotificationSupportedMode> supportedModes = this.aspspProfileServiceWrapper.getNotificationSupportedModes();
        if (supportedModes.contains(NotificationSupportedMode.NONE)) {
            return new NotificationModeResponseHeaders(null, null);
        }
        if (CollectionUtils.isEmpty(usedModes)) {
            log.info("TPP notification URI is not correct or requested modes are not supported!");
            return new NotificationModeResponseHeaders(false, null);
        }
        return new NotificationModeResponseHeaders(true, this.getModesAsString(usedModes));
    }

    public TppNotificationData getTppNotificationData(String tppNotificationContentPreferred, String tppNotificationUri) {
        List<NotificationSupportedMode> modesFromRequest = this.parseTppNotificationContentPreferred(tppNotificationContentPreferred);
        return new TppNotificationData(this.getProcessedNotificationModes(modesFromRequest), tppNotificationUri);
    }

    private String getModesAsString(List<NotificationSupportedMode> modes) {
        StringBuilder modesStr = new StringBuilder(HEADER_PREFIX);
        modesStr.append(StringUtils.join(modes, (String)MODES_SEPARATOR));
        return modesStr.toString();
    }

    private List<NotificationSupportedMode> getProcessedNotificationModes(List<NotificationSupportedMode> modesFromRequest) {
        List<NotificationSupportedMode> supportedModes = this.aspspProfileServiceWrapper.getNotificationSupportedModes();
        if (supportedModes.contains(NotificationSupportedMode.NONE)) {
            return Collections.emptyList();
        }
        return modesFromRequest.stream().filter(supportedModes::contains).collect(Collectors.toList());
    }

    private List<NotificationSupportedMode> parseTppNotificationContentPreferred(String tppNotificationContentPreferred) {
        if (StringUtils.isEmpty((CharSequence)tppNotificationContentPreferred)) {
            return Collections.emptyList();
        }
        String[] modes = tppNotificationContentPreferred.replace(HEADER_PREFIX, "").split(MODES_SEPARATOR);
        return Arrays.stream(modes).map(mode -> NotificationSupportedMode.getByValue((String)mode.trim())).filter(mode -> !mode.equals((Object)NotificationSupportedMode.NONE)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper"})
    public NotificationSupportedModeService(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

