/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.service.validator.TppNotificationDataValidator;
import de.adorsys.psd2.xs2a.service.validator.TppUriHeaderValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.CommonConsentObject;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.CreateConsentAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.CreateConsentRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.DeleteAccountConsentsByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetAccountConsentByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetAccountConsentsStatusByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationScaStatusPO;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationScaStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.UpdateConsentPsuDataValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.CreateConsentAuthorisationObject;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.CreateConsentRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.UpdateConsentPsuDataRequestObject;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class ConsentValidationService {
    private final CreateConsentRequestValidator createConsentRequestValidator;
    private final GetAccountConsentsStatusByIdValidator getAccountConsentsStatusByIdValidator;
    private final GetAccountConsentByIdValidator getAccountConsentByIdValidator;
    private final DeleteAccountConsentsByIdValidator deleteAccountConsentsByIdValidator;
    private final CreateConsentAuthorisationValidator createConsentAuthorisationValidator;
    private final UpdateConsentPsuDataValidator updateConsentPsuDataValidator;
    private final GetConsentAuthorisationsValidator getConsentAuthorisationsValidator;
    private final GetConsentAuthorisationScaStatusValidator getConsentAuthorisationScaStatusValidator;
    private final TppUriHeaderValidator tppUriHeaderValidator;
    private final TppNotificationDataValidator tppNotificationDataValidator;

    public ValidationResult validateConsentOnCreate(CreateConsentReq request, PsuIdData psuIdData) {
        return this.createConsentRequestValidator.validate(new CreateConsentRequestObject(request, psuIdData));
    }

    public ValidationResult validateConsentOnGettingStatusById(AisConsent consent) {
        return this.getAccountConsentsStatusByIdValidator.validate(new CommonConsentObject(consent));
    }

    public ValidationResult validateConsentOnDelete(AisConsent consent) {
        return this.deleteAccountConsentsByIdValidator.validate(new CommonConsentObject(consent));
    }

    public ValidationResult validateConsentOnGettingById(AisConsent consent) {
        return this.getAccountConsentByIdValidator.validate(new CommonConsentObject(consent));
    }

    public ValidationResult validateConsentAuthorisationOnCreate(CreateConsentAuthorisationObject createConsentAuthorisationObject) {
        return this.createConsentAuthorisationValidator.validate(createConsentAuthorisationObject);
    }

    public ValidationResult validateConsentPsuDataOnUpdate(AisConsent consent, ConsentAuthorisationsParameters request) {
        return this.updateConsentPsuDataValidator.validate(new UpdateConsentPsuDataRequestObject(consent, request));
    }

    public ValidationResult validateConsentAuthorisationOnGettingById(AisConsent consent) {
        return this.getConsentAuthorisationsValidator.validate(new CommonConsentObject(consent));
    }

    public ValidationResult validateConsentAuthorisationScaStatus(AisConsent consent, String authorisationId) {
        return this.getConsentAuthorisationScaStatusValidator.validate(new GetConsentAuthorisationScaStatusPO(consent, authorisationId));
    }

    public Set<TppMessageInformation> buildWarningMessages(CreateConsentReq request) {
        HashSet<TppMessageInformation> warnings = new HashSet<TppMessageInformation>();
        warnings.addAll(this.tppUriHeaderValidator.buildWarningMessages(request.getTppRedirectUri()));
        warnings.addAll(this.tppNotificationDataValidator.buildWarningMessages(request.getTppNotificationData()));
        return warnings;
    }

    @ConstructorProperties(value={"createConsentRequestValidator", "getAccountConsentsStatusByIdValidator", "getAccountConsentByIdValidator", "deleteAccountConsentsByIdValidator", "createConsentAuthorisationValidator", "updateConsentPsuDataValidator", "getConsentAuthorisationsValidator", "getConsentAuthorisationScaStatusValidator", "tppUriHeaderValidator", "tppNotificationDataValidator"})
    public ConsentValidationService(CreateConsentRequestValidator createConsentRequestValidator, GetAccountConsentsStatusByIdValidator getAccountConsentsStatusByIdValidator, GetAccountConsentByIdValidator getAccountConsentByIdValidator, DeleteAccountConsentsByIdValidator deleteAccountConsentsByIdValidator, CreateConsentAuthorisationValidator createConsentAuthorisationValidator, UpdateConsentPsuDataValidator updateConsentPsuDataValidator, GetConsentAuthorisationsValidator getConsentAuthorisationsValidator, GetConsentAuthorisationScaStatusValidator getConsentAuthorisationScaStatusValidator, TppUriHeaderValidator tppUriHeaderValidator, TppNotificationDataValidator tppNotificationDataValidator) {
        this.createConsentRequestValidator = createConsentRequestValidator;
        this.getAccountConsentsStatusByIdValidator = getAccountConsentsStatusByIdValidator;
        this.getAccountConsentByIdValidator = getAccountConsentByIdValidator;
        this.deleteAccountConsentsByIdValidator = deleteAccountConsentsByIdValidator;
        this.createConsentAuthorisationValidator = createConsentAuthorisationValidator;
        this.updateConsentPsuDataValidator = updateConsentPsuDataValidator;
        this.getConsentAuthorisationsValidator = getConsentAuthorisationsValidator;
        this.getConsentAuthorisationScaStatusValidator = getConsentAuthorisationScaStatusValidator;
        this.tppUriHeaderValidator = tppUriHeaderValidator;
        this.tppNotificationDataValidator = tppNotificationDataValidator;
    }
}

