/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.Xs2aResponse;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreateAisConsentResponse;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.ConsentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.StartAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.service.AdditionalInformationSupportedService;
import de.adorsys.psd2.xs2a.service.ConsentAuthorisationService;
import de.adorsys.psd2.xs2a.service.ConsentValidationService;
import de.adorsys.psd2.xs2a.service.PsuDataCleaner;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationChainResponsibilityService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.ConsentAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AisAuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountAccessMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aLinksMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private static final Logger log = LoggerFactory.getLogger(ConsentService.class);
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver;
    private final TppService tppService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final AisConsentSpi aisConsentSpi;
    private final Xs2aEventService xs2aEventService;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiToXs2aLinksMapper spiToXs2aLinksMapper;
    private final SpiErrorMapper spiErrorMapper;
    private final ScaMethodsMapper scaMethodsMapper;
    private final ConsentValidationService consentValidationService;
    private final ConsentAuthorisationService consentAuthorisationService;
    private final AisScaAuthorisationService aisScaAuthorisationService;
    private final RequestProviderService requestProviderService;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final LoggingContextService loggingContextService;
    private final AdditionalInformationSupportedService additionalInformationSupportedService;
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final PsuDataCleaner psuDataCleaner;
    private final ScaApproachResolver scaApproachResolver;
    private final AuthorisationChainResponsibilityService authorisationChainResponsibilityService;

    public ResponseObject<CreateConsentResponse> createAccountConsentsWithResponse(CreateConsentReq request, PsuIdData psuData, boolean explicitPreferred) {
        TppInfo tppInfo;
        Xs2aResponse<Xs2aCreateAisConsentResponse> xs2aResponse;
        ValidationResult validationResult;
        this.xs2aEventService.recordTppRequest(EventType.CREATE_AIS_CONSENT_REQUEST_RECEIVED, request);
        if (request.isOneAccessType()) {
            request.setFrequencyPerDay(1);
        }
        CreateConsentReq requestAfterCheck = this.additionalInformationSupportedService.checkIfAdditionalInformationSupported(request);
        PsuIdData checkedPsuIdData = psuData;
        if (this.aspspProfileService.isPsuInInitialRequestIgnored()) {
            checkedPsuIdData = this.psuDataCleaner.clearPsuData(checkedPsuIdData);
        }
        if ((validationResult = this.consentValidationService.validateConsentOnCreate(requestAfterCheck, checkedPsuIdData)).isNotValid()) {
            log.info("Create account consent with response - validation failed: {}", (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (requestAfterCheck.isGlobalOrAllAccountsAccessConsent()) {
            requestAfterCheck.setAccess(this.spiToXs2aAccountAccessMapper.getAccessForGlobalOrAllAvailableAccountsConsent(requestAfterCheck));
        }
        if ((xs2aResponse = this.aisConsentService.createConsent(requestAfterCheck, checkedPsuIdData, tppInfo = this.tppService.getTppInfo())).hasError()) {
            return this.resolveConsentCreationError(xs2aResponse.getErrors().stream().map(TppMessage::getErrorCode).collect(Collectors.toList()));
        }
        Xs2aCreateAisConsentResponse createAisConsentResponse = xs2aResponse.getPayload();
        SpiContextData contextData = this.spiContextDataProvider.provide(checkedPsuIdData, tppInfo);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        AisConsent aisConsent = createAisConsentResponse.getAisConsent();
        SpiResponse initiateAisConsentSpiResponse = this.aisConsentSpi.initiateAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(aisConsent), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        String encryptedConsentId = createAisConsentResponse.getConsentId();
        aspspConsentDataProvider.saveWith(encryptedConsentId);
        if (initiateAisConsentSpiResponse.hasError()) {
            this.aisConsentService.updateConsentStatus(encryptedConsentId, ConsentStatus.REJECTED);
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(initiateAisConsentSpiResponse, ServiceType.AIS);
            log.info("Consent-ID: [{}]. Create account consent  with response failed. Consent rejected. Couldn't initiate AIS consent at SPI level: {}", (Object)encryptedConsentId, (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        SpiInitiateAisConsentResponse spiResponsePayload = (SpiInitiateAisConsentResponse)initiateAisConsentSpiResponse.getPayload();
        boolean multilevelScaRequired = spiResponsePayload.isMultilevelScaRequired() && !this.aisScaAuthorisationService.isOneFactorAuthorisation(aisConsent);
        this.updateMultilevelSca(encryptedConsentId, multilevelScaRequired);
        Optional<AccountAccess> xs2aAccountAccess = this.spiToXs2aAccountAccessMapper.mapToAccountAccess(spiResponsePayload.getAccountAccess());
        xs2aAccountAccess.ifPresent(accountAccess -> this.accountReferenceUpdater.rewriteAccountAccess(encryptedConsentId, (AccountAccess)accountAccess, ConsentType.AIS));
        ConsentStatus consentStatus = aisConsent.getConsentStatus();
        CreateConsentResponse createConsentResponse = new CreateConsentResponse(consentStatus.getValue(), encryptedConsentId, this.scaMethodsMapper.mapToAuthenticationObjectList(spiResponsePayload.getScaMethods()), null, null, multilevelScaRequired, this.requestProviderService.getInternalRequestIdString(), createAisConsentResponse.getTppNotificationContentPreferred());
        createConsentResponse.setPsuMessage(spiResponsePayload.getPsuMessage());
        this.enrichTppMessages(requestAfterCheck, spiResponsePayload, createConsentResponse);
        ResponseObject<CreateConsentResponse> createConsentResponseObject = ResponseObject.builder().body(createConsentResponse).build();
        if (this.authorisationMethodDecider.isImplicitMethod(explicitPreferred, multilevelScaRequired)) {
            this.proceedImplicitCaseForCreateConsent(createConsentResponse, checkedPsuIdData, encryptedConsentId);
        }
        this.loggingContextService.storeConsentStatus(consentStatus);
        return createConsentResponseObject;
    }

    private void enrichTppMessages(CreateConsentReq requestAfterCheck, SpiInitiateAisConsentResponse spiResponsePayload, CreateConsentResponse createConsentResponse) {
        if (spiResponsePayload.getTppMessages() != null) {
            createConsentResponse.getTppMessageInformation().addAll(spiResponsePayload.getTppMessages());
        }
        createConsentResponse.getTppMessageInformation().addAll(this.consentValidationService.buildWarningMessages(requestAfterCheck));
    }

    private ResponseObject<CreateConsentResponse> resolveConsentCreationError(List<MessageErrorCode> errors) {
        if (errors.contains(MessageErrorCode.PSU_CREDENTIALS_INVALID)) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PSU_CREDENTIALS_INVALID)).build();
        }
        return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_400)).build();
    }

    private void updateMultilevelSca(String consentId, boolean multilevelScaRequired) {
        if (multilevelScaRequired) {
            this.aisConsentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
    }

    public ResponseObject<ConsentStatusResponse> getAccountConsentsStatusById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_AIS_CONSENT_STATUS_REQUEST_RECEIVED);
        ResponseObject.ResponseBuilder<ConsentStatusResponse> responseBuilder = ResponseObject.builder();
        Optional<AisConsent> validatedAisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (validatedAisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Get account consents status failed: consent not found by ID", (Object)consentId);
            return responseBuilder.fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AisConsent validatedAccountConsent = validatedAisConsentOptional.get();
        ValidationResult validationResult = this.consentValidationService.validateConsentOnGettingStatusById(validatedAccountConsent);
        if (validationResult.isNotValid()) {
            log.info("Get account consents status - validation failed: {}", (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        ConsentStatus consentStatus = validatedAccountConsent.getConsentStatus();
        if (consentStatus.isFinalisedStatus()) {
            this.loggingContextService.storeConsentStatus(consentStatus);
            return responseBuilder.body(new ConsentStatusResponse(consentStatus, null)).build();
        }
        SpiResponse<SpiConsentStatusResponse> spiResponse = this.getConsentStatusFromSpi(validatedAccountConsent, consentId);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            log.info("Get account consents status failed: Couldn't get AIS consent status at SPI level: {}", (Object)errorHolder);
            return responseBuilder.fail(new MessageError(errorHolder)).build();
        }
        SpiConsentStatusResponse spiPayload = (SpiConsentStatusResponse)spiResponse.getPayload();
        ConsentStatus spiConsentStatus = spiPayload.getConsentStatus();
        this.aisConsentService.updateConsentStatus(consentId, spiConsentStatus);
        this.loggingContextService.storeConsentStatus(spiConsentStatus);
        return responseBuilder.body(new ConsentStatusResponse(spiConsentStatus, spiPayload.getPsuMessage())).build();
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.DELETE_AIS_CONSENT_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isPresent()) {
            AisConsent accountConsent = aisConsentOptional.get();
            ValidationResult validationResult = this.consentValidationService.validateConsentOnDelete(accountConsent);
            if (validationResult.isNotValid()) {
                log.info("Consent-ID: [{}]. Delete account consent - validation failed: {}", (Object)accountConsent.getId(), (Object)validationResult.getMessageError());
                return ResponseObject.builder().fail(validationResult.getMessageError()).build();
            }
            SpiContextData contextData = this.getSpiContextData();
            SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
            SpiResponse revokeAisConsentResponse = this.aisConsentSpi.revokeAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), aspspDataProvider);
            if (revokeAisConsentResponse.hasError()) {
                ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(revokeAisConsentResponse, ServiceType.AIS);
                log.info("Consent-ID: [{}]. Delete account consent failed: Couldn't revoke AIS consent at SPI level: {}", (Object)accountConsent.getId(), (Object)errorHolder);
                return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
            }
            ConsentStatus newConsentStatus = accountConsent.getConsentStatus() == ConsentStatus.RECEIVED ? ConsentStatus.REJECTED : ConsentStatus.TERMINATED_BY_TPP;
            this.loggingContextService.storeConsentStatus(newConsentStatus);
            this.aisConsentService.updateConsentStatus(consentId, newConsentStatus);
            return ResponseObject.builder().build();
        }
        log.info("Consent-ID: [{}]. Delete account consent failed: consent not found by id", (Object)consentId);
        return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
    }

    public ResponseObject<AisConsent> getAccountConsentById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_AIS_CONSENT_REQUEST_RECEIVED);
        Optional<AisConsent> consentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (consentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Get account consent failed: initial consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AisConsent consent = consentOptional.get();
        ValidationResult validationResult = this.consentValidationService.validateConsentOnGettingById(consent);
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}]. Get account consent - validation failed: {}", (Object)consentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (Objects.nonNull(consent.getConsentStatus()) && consent.getConsentStatus().isFinalisedStatus()) {
            this.loggingContextService.storeConsentStatus(consent.getConsentStatus());
            return ResponseObject.builder().body(consent).build();
        }
        SpiResponse<SpiConsentStatusResponse> spiConsentStatus = this.getConsentStatusFromSpi(consent, consentId);
        if (spiConsentStatus.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiConsentStatus, ServiceType.AIS);
            log.info("Get account consents failed: Couldn't get AIS consent at SPI level: {}", (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        ConsentStatus consentStatus = ((SpiConsentStatusResponse)spiConsentStatus.getPayload()).getConsentStatus();
        this.aisConsentService.updateConsentStatus(consentId, consentStatus);
        this.loggingContextService.storeConsentStatus(consent.getConsentStatus());
        consent.setConsentStatus(consentStatus);
        return ResponseObject.builder().body(consent).build();
    }

    public ResponseObject<AuthorisationResponse> createAisAuthorisation(PsuIdData psuData, String consentId, String password) {
        return this.consentAuthorisationService.createAisAuthorisation(psuData, consentId, password);
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(ConsentAuthorisationsParameters updatePsuData) {
        return this.consentAuthorisationService.updateConsentPsuData(updatePsuData);
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        return this.consentAuthorisationService.getConsentInitiationAuthorisations(consentId);
    }

    public ResponseObject<Xs2aScaStatusResponse> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        SpiAccountConsent spiAccountConsent;
        ResponseObject<ConsentScaStatus> cmsScaStatusResponse = this.consentAuthorisationService.getConsentAuthorisationScaStatus(consentId, authorisationId);
        if (cmsScaStatusResponse.hasError()) {
            return ResponseObject.builder().fail(cmsScaStatusResponse.getError()).build();
        }
        SpiContextData contextData = this.getSpiContextData();
        SpiAspspConsentDataProvider spiAspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        ScaStatus scaStatus = cmsScaStatusResponse.getBody().getScaStatus();
        SpiResponse spiScaInformation = this.aisConsentSpi.getScaStatus(scaStatus, contextData, authorisationId, (Object)(spiAccountConsent = this.aisConsentMapper.mapToSpiAccountConsent(cmsScaStatusResponse.getBody().getAccountConsent())), spiAspspConsentDataProvider);
        if (spiScaInformation.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiScaInformation, ServiceType.AIS);
            log.info("Authorisation-ID [{}], Consent-ID [{}]. Get SCA status failed.", (Object)authorisationId, (Object)consentId);
            return ResponseObject.builder().fail(errorHolder).build();
        }
        SpiScaStatusResponse spiScaInformationPayload = (SpiScaStatusResponse)spiScaInformation.getPayload();
        if (scaStatus.isNotFinalisedStatus() && scaStatus != spiScaInformationPayload.getScaStatus()) {
            scaStatus = spiScaInformationPayload.getScaStatus();
            this.xs2aAuthorisationService.updateAuthorisationStatus(authorisationId, scaStatus);
            log.info("Authorisation-ID [{}], Consent-ID [{}]. SCA status was changed to [{}] from SPI.", new Object[]{authorisationId, consentId, scaStatus});
        }
        Boolean beneficiaryFlag = scaStatus.isFinalisedStatus() ? spiScaInformationPayload.getTrustedBeneficiaryFlag() : null;
        Xs2aScaStatusResponse response = new Xs2aScaStatusResponse(scaStatus, beneficiaryFlag, spiScaInformationPayload.getPsuMessage(), this.spiToXs2aLinksMapper.toXs2aLinks(spiScaInformationPayload.getLinks()), spiScaInformationPayload.getTppMessageInformation());
        return ResponseObject.builder().body(response).build();
    }

    private SpiResponse<SpiConsentStatusResponse> getConsentStatusFromSpi(AisConsent aisConsent, String consentId) {
        SpiAccountConsent spiAccountConsent = this.aisConsentMapper.mapToSpiAccountConsent(aisConsent);
        SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        return this.aisConsentSpi.getConsentStatus(this.spiContextDataProvider.provide(), spiAccountConsent, aspspDataProvider);
    }

    private void proceedImplicitCaseForCreateConsent(CreateConsentResponse createConsentResponse, PsuIdData psuIdData, String consentId) {
        ScaStatus scaStatus = ScaStatus.STARTED;
        String authorisationId = UUID.randomUUID().toString();
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        StartAuthorisationsParameters startAuthorisationsParameters = StartAuthorisationsParameters.builder().psuData(psuIdData).businessObjectId(consentId).scaStatus(scaStatus).authorisationId(authorisationId).build();
        Authorisation authorisation = new Authorisation(authorisationId, psuIdData, consentId, AuthorisationType.CONSENT, scaStatus);
        AisAuthorisationProcessorRequest processorRequest = new AisAuthorisationProcessorRequest(scaApproach, scaStatus, startAuthorisationsParameters, authorisation);
        CreateConsentAuthorisationProcessorResponse processorResponse = (CreateConsentAuthorisationProcessorResponse)this.authorisationChainResponsibilityService.apply(processorRequest);
        Xs2aCreateAuthorisationRequest createAuthorisationRequest = Xs2aCreateAuthorisationRequest.builder().psuData(psuIdData).consentId(consentId).authorisationId(authorisationId).scaStatus(processorResponse.getScaStatus()).scaApproach(processorResponse.getScaApproach()).build();
        ConsentAuthorizationService service = (ConsentAuthorizationService)this.aisScaAuthorisationServiceResolver.getService();
        Optional<CreateConsentAuthorizationResponse> consentAuthorizationResponse = service.createConsentAuthorization(createAuthorisationRequest);
        if (consentAuthorizationResponse.isPresent()) {
            CreateConsentAuthorizationResponse createConsentAuthorizationResponse = consentAuthorizationResponse.get();
            createConsentResponse.setAuthorizationId(createConsentAuthorizationResponse.getAuthorisationId());
            createConsentResponse.setScaStatus(createConsentAuthorizationResponse.getScaStatus());
            createConsentResponse.setScaApproach(createConsentAuthorizationResponse.getScaApproach());
            this.setPsuMessageAndTppMessages(createConsentResponse, processorResponse.getPsuMessage(), processorResponse.getTppMessages());
            this.loggingContextService.storeScaStatus(createConsentAuthorizationResponse.getScaStatus());
        }
    }

    private void setPsuMessageAndTppMessages(CreateConsentResponse response, String psuMessage, Set<TppMessageInformation> tppMessageInformationSet) {
        if (psuMessage != null) {
            response.setPsuMessage(psuMessage);
        }
        if (tppMessageInformationSet != null) {
            response.getTppMessageInformation().addAll(tppMessageInformationSet);
        }
    }

    private SpiContextData getSpiContextData() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("Corresponding PSU-ID {} was provided from request.", (Object)psuIdData);
        return this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
    }

    @ConstructorProperties(value={"aisConsentMapper", "spiToXs2aAccountAccessMapper", "aisConsentService", "aisScaAuthorisationServiceResolver", "tppService", "spiContextDataProvider", "authorisationMethodDecider", "aisConsentSpi", "xs2aEventService", "accountReferenceUpdater", "spiToXs2aLinksMapper", "spiErrorMapper", "scaMethodsMapper", "consentValidationService", "consentAuthorisationService", "aisScaAuthorisationService", "requestProviderService", "aspspConsentDataProviderFactory", "loggingContextService", "additionalInformationSupportedService", "xs2aAuthorisationService", "aspspProfileService", "psuDataCleaner", "scaApproachResolver", "authorisationChainResponsibilityService"})
    public ConsentService(Xs2aAisConsentMapper aisConsentMapper, SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper, Xs2aAisConsentService aisConsentService, AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver, TppService tppService, SpiContextDataProvider spiContextDataProvider, AuthorisationMethodDecider authorisationMethodDecider, AisConsentSpi aisConsentSpi, Xs2aEventService xs2aEventService, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiToXs2aLinksMapper spiToXs2aLinksMapper, SpiErrorMapper spiErrorMapper, ScaMethodsMapper scaMethodsMapper, ConsentValidationService consentValidationService, ConsentAuthorisationService consentAuthorisationService, AisScaAuthorisationService aisScaAuthorisationService, RequestProviderService requestProviderService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, LoggingContextService loggingContextService, AdditionalInformationSupportedService additionalInformationSupportedService, Xs2aAuthorisationService xs2aAuthorisationService, AspspProfileServiceWrapper aspspProfileService, PsuDataCleaner psuDataCleaner, ScaApproachResolver scaApproachResolver, AuthorisationChainResponsibilityService authorisationChainResponsibilityService) {
        this.aisConsentMapper = aisConsentMapper;
        this.spiToXs2aAccountAccessMapper = spiToXs2aAccountAccessMapper;
        this.aisConsentService = aisConsentService;
        this.aisScaAuthorisationServiceResolver = aisScaAuthorisationServiceResolver;
        this.tppService = tppService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.aisConsentSpi = aisConsentSpi;
        this.xs2aEventService = xs2aEventService;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiToXs2aLinksMapper = spiToXs2aLinksMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.scaMethodsMapper = scaMethodsMapper;
        this.consentValidationService = consentValidationService;
        this.consentAuthorisationService = consentAuthorisationService;
        this.aisScaAuthorisationService = aisScaAuthorisationService;
        this.requestProviderService = requestProviderService;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.loggingContextService = loggingContextService;
        this.additionalInformationSupportedService = additionalInformationSupportedService;
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.aspspProfileService = aspspProfileService;
        this.psuDataCleaner = psuDataCleaner;
        this.scaApproachResolver = scaApproachResolver;
        this.authorisationChainResponsibilityService = authorisationChainResponsibilityService;
    }
}

