/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.core.data.piis.PiisConsentData;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.model.ConsentConfirmationOfFundsContentResponse;
import de.adorsys.psd2.model.ConsentConfirmationOfFundsStatusResponse;
import de.adorsys.psd2.model.ConsentStatus;
import de.adorsys.psd2.model.ConsentsConfirmationOfFunds;
import de.adorsys.psd2.model.ConsentsConfirmationOfFundsResponse;
import de.adorsys.psd2.model.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aConfirmationOfFundsResponse;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppMessageGenericMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class PiisConsentModelMapper {
    private final HrefLinkMapper hrefLinkMapper;
    private final AccountModelMapper accountModelMapper;
    private final ConsentModelMapper consentModelMapper;
    private final CoreObjectsMapper coreObjectsMapper;
    private final TppMessageGenericMapper tppMessageGenericMapper;

    public CreatePiisConsentRequest toCreatePiisConsentRequest(ConsentsConfirmationOfFunds consentsConfirmationOfFunds) {
        return Optional.ofNullable(consentsConfirmationOfFunds).map(c -> new CreatePiisConsentRequest(this.consentModelMapper.mapToAccountReference(consentsConfirmationOfFunds.getAccount()), consentsConfirmationOfFunds.getCardNumber(), consentsConfirmationOfFunds.getCardExpiryDate(), consentsConfirmationOfFunds.getCardInformation(), consentsConfirmationOfFunds.getRegistrationInformation())).orElse(null);
    }

    public ConsentsConfirmationOfFundsResponse mapToConsentsConfirmationOfFundsResponse(Xs2aConfirmationOfFundsResponse xs2aConfirmationOfFundsResponse) {
        return Optional.ofNullable(xs2aConfirmationOfFundsResponse).map(response -> {
            ConsentsConfirmationOfFundsResponse consentsConfirmationOfFundsResponse = new ConsentsConfirmationOfFundsResponse();
            consentsConfirmationOfFundsResponse.setConsentId(response.getConsentId());
            consentsConfirmationOfFundsResponse.setConsentStatus(ConsentStatus.fromValue((String)response.getConsentStatus()));
            consentsConfirmationOfFundsResponse.setLinks(this.hrefLinkMapper.mapToLinksMap(response.getLinks()));
            consentsConfirmationOfFundsResponse.setPsuMessage(response.getPsuMessage());
            consentsConfirmationOfFundsResponse.setTppMessage(this.tppMessageGenericMapper.mapToTppMessageGenericList(response.getTppMessageInformation()));
            consentsConfirmationOfFundsResponse.setScaStatus((ScaStatus)Optional.ofNullable(response.getScaStatus()).map(this.coreObjectsMapper::mapToModelScaStatus).orElse(null));
            return consentsConfirmationOfFundsResponse;
        }).orElse(null);
    }

    public ConsentConfirmationOfFundsContentResponse mapToConsentConfirmationOfFundsContentResponse(PiisConsent piisConsent) {
        PiisConsentData consentData = (PiisConsentData)piisConsent.getConsentData();
        ConsentConfirmationOfFundsContentResponse consentConfirmationOfFundsContentResponse = new ConsentConfirmationOfFundsContentResponse();
        consentConfirmationOfFundsContentResponse.setAccount(this.accountModelMapper.mapToAccountReference(piisConsent.getAccountReference()));
        consentConfirmationOfFundsContentResponse.setConsentStatus(ConsentStatus.fromValue((String)piisConsent.getConsentStatus().getValue()));
        consentConfirmationOfFundsContentResponse.setCardInformation(consentData.getCardInformation());
        consentConfirmationOfFundsContentResponse.setCardExpiryDate(consentData.getCardExpiryDate());
        consentConfirmationOfFundsContentResponse.setCardNumber(consentData.getCardNumber());
        consentConfirmationOfFundsContentResponse.setRegistrationInformation(consentData.getRegistrationInformation());
        return consentConfirmationOfFundsContentResponse;
    }

    public ConsentConfirmationOfFundsStatusResponse mapToConsentConfirmationOfFundsStatusResponse(ConsentStatusResponse consentStatusResponse) {
        ConsentConfirmationOfFundsStatusResponse consentConfirmationOfFundsStatusResponse = new ConsentConfirmationOfFundsStatusResponse();
        consentConfirmationOfFundsStatusResponse.setConsentStatus(ConsentStatus.fromValue((String)consentStatusResponse.getConsentStatus()));
        return consentConfirmationOfFundsStatusResponse;
    }

    @ConstructorProperties(value={"hrefLinkMapper", "accountModelMapper", "consentModelMapper", "coreObjectsMapper", "tppMessageGenericMapper"})
    public PiisConsentModelMapper(HrefLinkMapper hrefLinkMapper, AccountModelMapper accountModelMapper, ConsentModelMapper consentModelMapper, CoreObjectsMapper coreObjectsMapper, TppMessageGenericMapper tppMessageGenericMapper) {
        this.hrefLinkMapper = hrefLinkMapper;
        this.accountModelMapper = accountModelMapper;
        this.consentModelMapper = consentModelMapper;
        this.coreObjectsMapper = coreObjectsMapper;
        this.tppMessageGenericMapper = tppMessageGenericMapper;
    }
}

