/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.BalanceList;
import de.adorsys.psd2.model.BalanceType;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.OffsetDateTimeMapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={AmountModelMapper.class, OffsetDateTimeMapper.class})
public abstract class BalanceMapper {
    @Autowired
    protected OffsetDateTimeMapper offsetDateTimeMapper;

    @Mappings(value={@Mapping(target="balanceType", expression="java(mapToBalanceType(balance.getBalanceType()))"), @Mapping(target="lastChangeDateTime", expression="java(offsetDateTimeMapper.mapToOffsetDateTime(balance.getLastChangeDateTime()))")})
    public abstract Balance mapToBalance(Xs2aBalance var1);

    public BalanceList mapToBalanceList(List<Xs2aBalance> balances) {
        BalanceList balanceList = null;
        if (CollectionUtils.isNotEmpty(balances)) {
            balanceList = new BalanceList();
            balanceList.addAll((Collection)balances.stream().map(this::mapToBalance).collect(Collectors.toList()));
        }
        return balanceList;
    }

    public BalanceType mapToBalanceType(de.adorsys.psd2.xs2a.domain.BalanceType balanceType) {
        if (balanceType == null) {
            return null;
        }
        return BalanceType.fromValue((String)balanceType.getValue());
    }
}

