/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;

public abstract class UpdateConsentLinks
extends AbstractLinks {
    protected UpdateConsentLinks(String httpUrl, ScaApproachResolver scaApproachResolver, UpdateConsentPsuDataResponse response) {
        super(httpUrl);
        String consentId = response.getConsentId();
        String authorisationId = response.getAuthorisationId();
        ScaStatus scaStatus = response.getScaStatus();
        HrefType authorisationLink = this.buildPath(this.getPath(), consentId, authorisationId);
        this.setScaStatus(authorisationLink);
        if (scaStatus == ScaStatus.PSUAUTHENTICATED) {
            this.setSelectAuthenticationMethod(authorisationLink);
        } else if (scaStatus == ScaStatus.SCAMETHODSELECTED) {
            ScaApproach scaApproach = scaApproachResolver.getScaApproach(authorisationId);
            if (scaApproach != ScaApproach.DECOUPLED) {
                this.setAuthoriseTransaction(authorisationLink);
            }
        } else if (scaStatus == ScaStatus.PSUIDENTIFIED) {
            this.setUpdatePsuAuthentication(authorisationLink);
        }
    }

    abstract String getPath();
}

