/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import de.adorsys.psd2.xs2a.web.link.holder.LinkParameters;

public class PaymentCancellationLinks
extends AbstractLinks {
    private final ScaApproachResolver scaApproachResolver;
    private final RedirectLinkBuilder redirectLinkBuilder;
    private final RedirectIdService redirectIdService;
    private final ScaRedirectFlow scaRedirectFlow;
    private final LinkParameters linkParameters;

    public PaymentCancellationLinks(LinkParameters linkParameters, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, CancelPaymentResponse response, ScaRedirectFlow scaRedirectFlow) {
        super(linkParameters.getHttpUrl());
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.redirectIdService = redirectIdService;
        this.scaRedirectFlow = scaRedirectFlow;
        this.linkParameters = linkParameters;
        this.buildCancellationLinks(response);
    }

    private void buildCancellationLinks(CancelPaymentResponse body) {
        if (TransactionStatus.RJCT == body.getTransactionStatus()) {
            return;
        }
        String paymentId = body.getPaymentId();
        String paymentService = body.getPaymentType().getValue();
        String paymentProduct = body.getPaymentProduct();
        String authorisationId = body.getAuthorizationId();
        String internalRequestId = body.getInternalRequestId();
        this.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentService, paymentProduct, paymentId));
        this.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentService, paymentProduct, paymentId));
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        if (scaApproach == ScaApproach.EMBEDDED) {
            this.addEmbeddedRelatedLinks(paymentService, paymentProduct, paymentId, authorisationId);
        } else if (scaApproach == ScaApproach.REDIRECT) {
            this.addRedirectRelatedLinks(paymentService, paymentProduct, paymentId, authorisationId, internalRequestId);
        } else if (scaApproach == ScaApproach.DECOUPLED) {
            this.addDecoupledRelatedLinks(paymentService, paymentProduct, paymentId, authorisationId);
        }
    }

    private void addEmbeddedRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorisationId) {
        if (this.linkParameters.isExplicitMethod()) {
            this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations", paymentService, paymentProduct, paymentId));
        } else {
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
            this.setUpdatePsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        }
    }

    private void addDecoupledRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorisationId) {
        if (this.linkParameters.isExplicitMethod()) {
            this.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations", paymentService, paymentProduct, paymentId));
        } else {
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        }
    }

    private void addRedirectRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorisationId, String internalRequestId) {
        if (this.linkParameters.isExplicitMethod()) {
            this.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations", paymentService, paymentProduct, paymentId));
        } else {
            String redirectId = this.redirectIdService.generateRedirectId(authorisationId);
            String paymentCancellationOauthLink = this.scaRedirectFlow == ScaRedirectFlow.OAUTH ? this.redirectLinkBuilder.buildPaymentCancellationScaOauthRedirectLink(paymentId, redirectId, internalRequestId) : this.redirectLinkBuilder.buildPaymentCancellationScaRedirectLink(paymentId, redirectId, internalRequestId, this.linkParameters.getInstanceId());
            this.setScaRedirect(new HrefType(paymentCancellationOauthLink));
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
            if (this.linkParameters.isAuthorisationConfirmationRequestMandated()) {
                this.setConfirmation(this.buildPath(this.redirectLinkBuilder.buildPisCancellationConfirmationLink(paymentService, paymentProduct, paymentId, redirectId), new Object[0]));
            }
        }
    }
}

