/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation;

import de.adorsys.psd2.consent.api.pis.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationPsuDataChecker;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationStatusChecker;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.CreatePisAuthorisationObject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreatePisAuthorisationValidator
extends AbstractPisValidator<CreatePisAuthorisationObject> {
    private static final Logger log = LoggerFactory.getLogger(CreatePisAuthorisationValidator.class);
    private final AuthorisationPsuDataChecker authorisationPsuDataChecker;
    private final AuthorisationStatusChecker authorisationStatusChecker;

    public CreatePisAuthorisationValidator(AuthorisationPsuDataChecker authorisationPsuDataChecker, AuthorisationStatusChecker authorisationStatusChecker) {
        this.authorisationPsuDataChecker = authorisationPsuDataChecker;
        this.authorisationStatusChecker = authorisationStatusChecker;
    }

    @Override
    protected ValidationResult executeBusinessValidation(CreatePisAuthorisationObject createPisAuthorisationObject) {
        PisCommonPaymentResponse pisCommonPaymentResponse = createPisAuthorisationObject.getPisCommonPaymentResponse();
        if (pisCommonPaymentResponse.isSigningBasketBlocked()) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_400, (MessageErrorCode)MessageErrorCode.RESOURCE_BLOCKED_SB);
        }
        if (pisCommonPaymentResponse.isSigningBasketAuthorised()) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_400, (MessageErrorCode)MessageErrorCode.STATUS_INVALID);
        }
        PsuIdData psuDataFromRequest = createPisAuthorisationObject.getPsuDataFromRequest();
        List psuDataFromDb = createPisAuthorisationObject.getPisCommonPaymentResponse().getPsuData();
        if (this.authorisationPsuDataChecker.isPsuDataWrong(pisCommonPaymentResponse.isMultilevelScaRequired(), psuDataFromDb, psuDataFromRequest)) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_401, (MessageErrorCode)MessageErrorCode.PSU_CREDENTIALS_INVALID);
        }
        boolean isFinalised = this.authorisationStatusChecker.isFinalised(psuDataFromRequest, pisCommonPaymentResponse.getAuthorisations(), AuthorisationType.PIS_CREATION);
        if (isFinalised) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_409, (MessageErrorCode)MessageErrorCode.STATUS_INVALID);
        }
        if (pisCommonPaymentResponse.getTransactionStatus() == TransactionStatus.RJCT) {
            log.info("Payment ID: [{}]. Creation of PIS authorisation has failed: payment has been rejected", (Object)pisCommonPaymentResponse.getExternalId());
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_403, (MessageErrorCode)MessageErrorCode.RESOURCE_EXPIRED_403);
        }
        return ValidationResult.valid();
    }
}

