/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation;

import de.adorsys.psd2.consent.api.pis.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationPsuDataChecker;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationStatusChecker;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.CreatePisCancellationAuthorisationObject;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CreatePisCancellationAuthorisationValidator
extends AbstractPisValidator<CreatePisCancellationAuthorisationObject> {
    private final AuthorisationPsuDataChecker authorisationPsuDataChecker;
    private final AuthorisationStatusChecker authorisationStatusChecker;

    public CreatePisCancellationAuthorisationValidator(AuthorisationPsuDataChecker authorisationPsuDataChecker, AuthorisationStatusChecker authorisationStatusChecker) {
        this.authorisationPsuDataChecker = authorisationPsuDataChecker;
        this.authorisationStatusChecker = authorisationStatusChecker;
    }

    @Override
    protected ValidationResult executeBusinessValidation(CreatePisCancellationAuthorisationObject createPisCancellationAuthorisationObject) {
        PsuIdData psuDataFromRequest = createPisCancellationAuthorisationObject.getPsuData();
        PisCommonPaymentResponse pisCommonPaymentResponse = createPisCancellationAuthorisationObject.getPisCommonPaymentResponse();
        List psuDataFromDb = pisCommonPaymentResponse.getPsuData();
        if (this.authorisationPsuDataChecker.isPsuDataWrong(pisCommonPaymentResponse.isMultilevelScaRequired(), psuDataFromDb, psuDataFromRequest)) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_401, (MessageErrorCode)MessageErrorCode.PSU_CREDENTIALS_INVALID);
        }
        boolean isFinalised = this.authorisationStatusChecker.isFinalised(psuDataFromRequest, pisCommonPaymentResponse.getAuthorisations(), AuthorisationType.PIS_CANCELLATION);
        if (isFinalised) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_409, (MessageErrorCode)MessageErrorCode.STATUS_INVALID);
        }
        return ValidationResult.valid();
    }
}

