/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.validator.PsuDataUpdateAuthorisationChecker;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PsuDataUpdateAuthorisationCheckerValidator {
    private static final Logger log = LoggerFactory.getLogger(PsuDataUpdateAuthorisationCheckerValidator.class);
    private final RequestProviderService requestProviderService;
    private final PsuDataUpdateAuthorisationChecker psuDataUpdateAuthorisationChecker;

    @NotNull
    public ValidationResult validate(@NotNull PsuIdData psuIdDataRequest, @Nullable PsuIdData psuIdDataAuthorisation) {
        if (this.psuDataUpdateAuthorisationChecker.areBothPsusAbsent(psuIdDataRequest, psuIdDataAuthorisation)) {
            log.info("PsuID-Request: [{}], PsuID-Authorisation: [{}]. Updating PSU Data has failed: PSU from request and PSU from authorisation are absent", (Object)psuIdDataRequest, (Object)psuIdDataAuthorisation);
            return ValidationResult.invalid((MessageError)this.getMessageErrorAreBothPsusAbsent());
        }
        if (!this.psuDataUpdateAuthorisationChecker.canPsuUpdateAuthorisation(psuIdDataRequest, psuIdDataAuthorisation)) {
            log.info("PsuID-Request: [{}], PsuID-Authorisation: [{}]. Updating PSU Data has failed: PSU from authorisation and PSU from request are different", (Object)psuIdDataRequest, (Object)psuIdDataAuthorisation);
            return ValidationResult.invalid((MessageError)this.getMessageErrorCanPsuUpdateAuthorisation());
        }
        return ValidationResult.valid();
    }

    public abstract MessageError getMessageErrorAreBothPsusAbsent();

    public abstract MessageError getMessageErrorCanPsuUpdateAuthorisation();

    @ConstructorProperties(value={"requestProviderService", "psuDataUpdateAuthorisationChecker"})
    public PsuDataUpdateAuthorisationCheckerValidator(RequestProviderService requestProviderService, PsuDataUpdateAuthorisationChecker psuDataUpdateAuthorisationChecker) {
        this.requestProviderService = requestProviderService;
        this.psuDataUpdateAuthorisationChecker = psuDataUpdateAuthorisationChecker;
    }
}

