/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.event;

import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.xs2a.domain.authorisation.CommonAuthorisationParameters;
import de.adorsys.psd2.xs2a.service.event.EventAuthorisationType;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class EventTypeService {
    public EventType getEventType(CommonAuthorisationParameters updateAuthorisationRequest, EventAuthorisationType eventAuthorisationType) {
        return this.getUpdateEventType(updateAuthorisationRequest).getEventType(eventAuthorisationType);
    }

    private UpdateEventType getUpdateEventType(CommonAuthorisationParameters updateAuthorisationRequest) {
        if (updateAuthorisationRequest.getConfirmationCode() != null) {
            return UpdateEventType.CONFIRMATION_CODE;
        }
        if (updateAuthorisationRequest.getScaAuthenticationData() != null) {
            return UpdateEventType.TAN;
        }
        if (updateAuthorisationRequest.getAuthenticationMethodId() != null) {
            return UpdateEventType.SELECT_AUTHENTICATION_METHOD;
        }
        if (updateAuthorisationRequest.getPassword() != null) {
            return UpdateEventType.AUTHENTICATION;
        }
        return UpdateEventType.IDENTIFICATION;
    }

    private static enum UpdateEventType {
        IDENTIFICATION(Map.of(EventAuthorisationType.AIS, EventType.UPDATE_AIS_CONSENT_PSU_DATA_IDENTIFICATION_REQUEST_RECEIVED, EventAuthorisationType.SB, EventType.UPDATE_SB_PSU_DATA_IDENTIFICATION_REQUEST_RECEIVED, EventAuthorisationType.PIIS, EventType.UPDATE_PIIS_CONSENT_PSU_DATA_IDENTIFICATION_REQUEST_RECEIVED, EventAuthorisationType.PIS, EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_IDENTIFICATION_REQUEST_RECEIVED, EventAuthorisationType.PIS_CANCELLATION, EventType.UPDATE_PAYMENT_CANCELLATION_PSU_DATA_IDENTIFICATION_REQUEST_RECEIVED)),
        AUTHENTICATION(Map.of(EventAuthorisationType.AIS, EventType.UPDATE_AIS_CONSENT_PSU_DATA_AUTHENTICATION_REQUEST_RECEIVED, EventAuthorisationType.SB, EventType.UPDATE_SB_PSU_DATA_AUTHENTICATION_REQUEST_RECEIVED, EventAuthorisationType.PIIS, EventType.UPDATE_PIIS_CONSENT_PSU_DATA_AUTHENTICATION_REQUEST_RECEIVED, EventAuthorisationType.PIS, EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_AUTHENTICATION_REQUEST_RECEIVED, EventAuthorisationType.PIS_CANCELLATION, EventType.UPDATE_PAYMENT_CANCELLATION_PSU_DATA_AUTHENTICATION_REQUEST_RECEIVED)),
        SELECT_AUTHENTICATION_METHOD(Map.of(EventAuthorisationType.AIS, EventType.UPDATE_AIS_CONSENT_PSU_DATA_SELECT_AUTHENTICATION_METHOD_REQUEST_RECEIVED, EventAuthorisationType.SB, EventType.UPDATE_SB_PSU_DATA_SELECT_AUTHENTICATION_METHOD_REQUEST_RECEIVED, EventAuthorisationType.PIIS, EventType.UPDATE_PIIS_CONSENT_PSU_DATA_SELECT_AUTHENTICATION_METHOD_REQUEST_RECEIVED, EventAuthorisationType.PIS, EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_SELECT_AUTHENTICATION_METHOD_REQUEST_RECEIVED, EventAuthorisationType.PIS_CANCELLATION, EventType.UPDATE_PAYMENT_CANCELLATION_PSU_DATA_SELECT_AUTHENTICATION_METHOD_REQUEST_RECEIVED)),
        TAN(Map.of(EventAuthorisationType.AIS, EventType.UPDATE_AIS_CONSENT_PSU_DATA_TAN_REQUEST_RECEIVED, EventAuthorisationType.SB, EventType.UPDATE_SB_PSU_DATA_TAN_REQUEST_RECEIVED, EventAuthorisationType.PIIS, EventType.UPDATE_PIIS_CONSENT_PSU_DATA_TAN_REQUEST_RECEIVED, EventAuthorisationType.PIS, EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_TAN_REQUEST_RECEIVED, EventAuthorisationType.PIS_CANCELLATION, EventType.UPDATE_PAYMENT_CANCELLATION_PSU_DATA_TAN_REQUEST_RECEIVED)),
        CONFIRMATION_CODE(Map.of(EventAuthorisationType.AIS, EventType.UPDATE_AIS_CONSENT_PSU_DATA_CONFIRMATION_CODE_REQUEST_RECEIVED, EventAuthorisationType.SB, EventType.UPDATE_SB_PSU_DATA_CONFIRMATION_CODE_REQUEST_RECEIVED, EventAuthorisationType.PIIS, EventType.UPDATE_PIIS_CONSENT_PSU_DATA_CONFIRMATION_CODE_REQUEST_RECEIVED, EventAuthorisationType.PIS, EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_CONFIRMATION_CODE_REQUEST_RECEIVED, EventAuthorisationType.PIS_CANCELLATION, EventType.UPDATE_PAYMENT_CANCELLATION_PSU_DATA_CONFIRMATION_CODE_REQUEST_RECEIVED));

        private Map<EventAuthorisationType, EventType> eventServiceTypes;

        private UpdateEventType(Map<EventAuthorisationType, EventType> eventServiceTypes) {
            this.eventServiceTypes = eventServiceTypes;
        }

        public EventType getEventType(EventAuthorisationType eventAuthorisationType) {
            return this.eventServiceTypes.get((Object)eventAuthorisationType);
        }
    }
}

