/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aConsentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aConsentService.class);
    private final Xs2aAuthorisationService authorisationService;

    public Optional<CreateAuthorisationResponse> createConsentAuthorisation(String consentId, CreateAuthorisationRequest request) {
        return this.authorisationService.createAuthorisation(request, consentId, AuthorisationType.CONSENT);
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.authorisationService.getAuthorisationScaStatus(authorisationId, consentId, AuthorisationType.CONSENT);
    }

    @ConstructorProperties(value={"authorisationService"})
    public Xs2aConsentService(Xs2aAuthorisationService authorisationService) {
        this.authorisationService = authorisationService;
    }
}

