/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.PaymentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aLinksMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaymentServiceForAuthorisation {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceForAuthorisation.class);
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final RequestProviderService requestProviderService;
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final Xs2aToSpiPaymentMapper xs2aToSpiPaymentMapper;
    private final SpiToXs2aLinksMapper spiToXs2aLinksMapper;

    public ResponseObject<Xs2aScaStatusResponse> getAuthorisationScaStatus(String paymentId, String authorisationId, PaymentType paymentType, String paymentProduct) {
        SpiPayment spiPayment;
        ResponseObject<PaymentScaStatus> paymentScaStatusResponse = this.getCMSScaStatus(paymentId, authorisationId, paymentType, paymentProduct);
        if (paymentScaStatusResponse.hasError()) {
            return ResponseObject.builder().fail(paymentScaStatusResponse.getError()).build();
        }
        SpiContextData contextData = this.getSpiContextData();
        SpiAspspConsentDataProvider spiAspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(paymentId);
        ScaStatus scaStatus = paymentScaStatusResponse.getBody().getScaStatus();
        SpiResponse<SpiScaStatusResponse> spiScaStatusResponse = this.getScaStatus(scaStatus, contextData, authorisationId, spiPayment = this.xs2aToSpiPaymentMapper.mapToSpiPayment(paymentScaStatusResponse.getBody().getPisCommonPaymentResponse()), spiAspspConsentDataProvider);
        if (spiScaStatusResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiScaStatusResponse, ServiceType.PIS);
            log.info("Authorisation-ID [{}], Payment-ID [{}]. Get SCA status failed.", (Object)authorisationId, (Object)paymentId);
            return ResponseObject.builder().fail(errorHolder).build();
        }
        SpiScaStatusResponse spiScaInformationPayload = (SpiScaStatusResponse)spiScaStatusResponse.getPayload();
        if (scaStatus.isNotFinalisedStatus() && scaStatus != spiScaInformationPayload.getScaStatus()) {
            scaStatus = spiScaInformationPayload.getScaStatus();
            this.xs2aAuthorisationService.updateAuthorisationStatus(authorisationId, scaStatus);
            log.info("Authorisation-ID [{}], Payment-ID [{}]. SCA status was changed to [{}] from SPI.", new Object[]{authorisationId, paymentId, scaStatus});
        }
        Boolean beneficiaryFlag = scaStatus.isFinalisedStatus() ? spiScaInformationPayload.getTrustedBeneficiaryFlag() : null;
        Xs2aScaStatusResponse response = new Xs2aScaStatusResponse(scaStatus, beneficiaryFlag, spiScaInformationPayload.getPsuMessage(), this.spiToXs2aLinksMapper.toXs2aLinks(spiScaInformationPayload.getLinks()), spiScaInformationPayload.getTppMessageInformation());
        return ResponseObject.builder().body(response).build();
    }

    abstract ResponseObject<PaymentScaStatus> getCMSScaStatus(String var1, String var2, PaymentType var3, String var4);

    abstract SpiResponse<SpiScaStatusResponse> getScaStatus(@NotNull ScaStatus var1, @NotNull SpiContextData var2, @NotNull String var3, @NotNull SpiPayment var4, @NotNull SpiAspspConsentDataProvider var5);

    private SpiContextData getSpiContextData() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("Corresponding PSU-ID {} was provided from request.", (Object)psuIdData);
        return this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
    }

    @ConstructorProperties(value={"spiContextDataProvider", "aspspConsentDataProviderFactory", "spiErrorMapper", "requestProviderService", "xs2aAuthorisationService", "xs2aToSpiPaymentMapper", "spiToXs2aLinksMapper"})
    public PaymentServiceForAuthorisation(SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, RequestProviderService requestProviderService, Xs2aAuthorisationService xs2aAuthorisationService, Xs2aToSpiPaymentMapper xs2aToSpiPaymentMapper, SpiToXs2aLinksMapper spiToXs2aLinksMapper) {
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.requestProviderService = requestProviderService;
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.xs2aToSpiPaymentMapper = xs2aToSpiPaymentMapper;
        this.spiToXs2aLinksMapper = spiToXs2aLinksMapper;
    }
}

