/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.ConsentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.StartAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreateAuthorisationRequest;
import de.adorsys.psd2.xs2a.service.ConsentValidationService;
import de.adorsys.psd2.xs2a.service.PsuIdDataAuthorisationService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationChainResponsibilityService;
import de.adorsys.psd2.xs2a.service.authorization.ConsentAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorisationConfirmationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AisAuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.EventAuthorisationType;
import de.adorsys.psd2.xs2a.service.event.EventTypeService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.validator.ConsentEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.CreateConsentAuthorisationObject;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConsentAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(ConsentAuthorisationService.class);
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final Xs2aAisConsentService aisConsentService;
    private final AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver;
    private final ConsentEndpointAccessCheckerService endpointAccessCheckerService;
    private final Xs2aEventService xs2aEventService;
    private final ConsentValidationService consentValidationService;
    private final AuthorisationChainResponsibilityService authorisationChainResponsibilityService;
    private final LoggingContextService loggingContextService;
    private final AisAuthorisationConfirmationService aisAuthorisationConfirmationService;
    private final PsuIdDataAuthorisationService psuIdDataAuthorisationService;
    private final EventTypeService eventTypeService;
    private final ScaApproachResolver scaApproachResolver;

    public ResponseObject<AuthorisationResponse> createAisAuthorisation(PsuIdData psuData, String consentId, String password) {
        ResponseObject<CreateConsentAuthorizationResponse> createAisAuthorizationResponse = this.createConsentAuthorizationWithResponse(psuData, consentId);
        if (createAisAuthorizationResponse.hasError()) {
            return ResponseObject.builder().fail(createAisAuthorizationResponse.getError()).build();
        }
        PsuIdData psuIdDataFromResponse = createAisAuthorizationResponse.getBody().getPsuIdData();
        if (psuIdDataFromResponse == null || psuIdDataFromResponse.isEmpty() || StringUtils.isBlank((CharSequence)password)) {
            this.loggingContextService.storeScaStatus(createAisAuthorizationResponse.getBody().getScaStatus());
            return ResponseObject.builder().body(createAisAuthorizationResponse.getBody()).build();
        }
        String authorisationId = createAisAuthorizationResponse.getBody().getAuthorisationId();
        ConsentAuthorisationsParameters updatePsuData = new ConsentAuthorisationsParameters();
        updatePsuData.setPsuData(psuData);
        updatePsuData.setConsentId(consentId);
        updatePsuData.setAuthorizationId(authorisationId);
        updatePsuData.setPassword(password);
        ResponseObject<UpdateConsentPsuDataResponse> updatePsuDataResponse = this.updateConsentPsuData(updatePsuData);
        if (updatePsuDataResponse.hasError()) {
            return ResponseObject.builder().fail(updatePsuDataResponse.getError()).build();
        }
        return ResponseObject.builder().body(updatePsuDataResponse.getBody()).build();
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Get consent initiation authorisations failed: consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.consentValidationService.validateConsentAuthorisationOnGettingById(aisConsent);
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}]. Get consent authorisations - validation failed: {}", (Object)consentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        return this.getAuthorisationSubResources(consentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(() -> {
            log.info("Consent-ID: [{}]. Get consent initiation authorisations failed: authorisation not found at CMS by consent id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        });
    }

    public ResponseObject<ConsentScaStatus> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_CONSENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Get consent authorisation SCA status failed: consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AisConsent accountConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.consentValidationService.validateConsentAuthorisationScaStatus(accountConsent, authorisationId);
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}], Authorisation-ID [{}]. Get consent authorisation SCA status - validation failed: {}", new Object[]{consentId, authorisationId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        ConsentAuthorizationService authorizationService = (ConsentAuthorizationService)this.aisScaAuthorisationServiceResolver.getService(authorisationId);
        Optional<ScaStatus> scaStatusOptional = authorizationService.getAuthorisationScaStatus(consentId, authorisationId);
        if (scaStatusOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Get consent authorisation SCA status failed: consent not found at CMS by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        ScaStatus scaStatus = scaStatusOptional.get();
        PsuIdData psuIdData = this.psuIdDataAuthorisationService.getPsuIdData(authorisationId, accountConsent.getPsuIdDataList());
        ConsentScaStatus consentScaStatus = new ConsentScaStatus(psuIdData, accountConsent, scaStatus);
        this.loggingContextService.storeConsentStatus(accountConsent.getConsentStatus());
        this.loggingContextService.storeScaStatus(scaStatus);
        return ResponseObject.builder().body(consentScaStatus).build();
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(ConsentAuthorisationsParameters updatePsuData) {
        boolean confirmationCodeReceived;
        this.xs2aEventService.recordConsentTppRequest(updatePsuData.getConsentId(), this.eventTypeService.getEventType(updatePsuData, EventAuthorisationType.AIS), updatePsuData);
        String consentId = updatePsuData.getConsentId();
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Update consent PSU data failed: consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        String authorisationId = updatePsuData.getAuthorizationId();
        if (!this.endpointAccessCheckerService.isEndpointAccessible(authorisationId, confirmationCodeReceived = StringUtils.isNotBlank((CharSequence)updatePsuData.getConfirmationCode()))) {
            log.info("Consent-ID: [{}], Authorisation-ID [{}]. Update consent PSU data failed: update endpoint is blocked for current authorisation", (Object)consentId, (Object)authorisationId);
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SERVICE_BLOCKED)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        ValidationResult validationResult = this.consentValidationService.validateConsentPsuDataOnUpdate(aisConsent, updatePsuData);
        if (validationResult.isNotValid()) {
            MessageErrorCode messageErrorCode = validationResult.getMessageError().getTppMessage().getMessageErrorCode();
            if (EnumSet.of(MessageErrorCode.PSU_CREDENTIALS_INVALID, MessageErrorCode.FORMAT_ERROR_NO_PSU).contains(messageErrorCode)) {
                this.xs2aAuthorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            }
            log.info("Consent-ID: [{}], Authorisation-ID [{}]. Update consent PSU data - validation failed: {}", new Object[]{consentId, authorisationId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (aisConsent.isExpired()) {
            log.info("Consent-ID: [{}]. Update consent PSU data failed: consent expired", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        return this.getUpdateConsentPsuDataResponse(updatePsuData);
    }

    private ResponseObject<UpdateConsentPsuDataResponse> getUpdateConsentPsuDataResponse(ConsentAuthorisationsParameters updatePsuData) {
        ConsentAuthorizationService service = (ConsentAuthorizationService)this.aisScaAuthorisationServiceResolver.getService(updatePsuData.getAuthorizationId());
        Optional<Authorisation> authorizationOptional = service.getConsentAuthorizationById(updatePsuData.getAuthorizationId());
        if (authorizationOptional.isEmpty()) {
            log.info("Authorisation-ID: [{}]. Update consent PSU data failed: authorisation not found by id", (Object)updatePsuData.getAuthorizationId());
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        Authorisation authorisation = authorizationOptional.get();
        if (authorisation.getChosenScaApproach() == ScaApproach.REDIRECT) {
            return this.aisAuthorisationConfirmationService.processAuthorisationConfirmation(updatePsuData);
        }
        UpdateConsentPsuDataResponse response = (UpdateConsentPsuDataResponse)this.authorisationChainResponsibilityService.apply(new AisAuthorisationProcessorRequest(authorisation.getChosenScaApproach(), authorisation.getScaStatus(), updatePsuData, authorisation));
        this.loggingContextService.storeScaStatus(response.getScaStatus());
        return Optional.ofNullable(response).map(s -> Optional.ofNullable(s.getErrorHolder()).map(e -> ResponseObject.builder().fail((ErrorHolder)e).build()).orElseGet(ResponseObject.builder().body(response)::build)).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR))::build);
    }

    private ResponseObject<CreateConsentAuthorizationResponse> createConsentAuthorizationWithResponse(PsuIdData psuDataFromRequest, String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.START_AIS_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Create consent authorisation with response failed: consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.consentValidationService.validateConsentAuthorisationOnCreate(new CreateConsentAuthorisationObject(aisConsent, psuDataFromRequest));
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}]. Create consent authorisation with response - validation failed: {}", (Object)consentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (aisConsent.isExpired()) {
            log.info("Consent-ID: [{}]. Create consent authorisation with response failed: consent expired", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        PsuIdData psuIdData = this.getActualPsuData(psuDataFromRequest, aisConsent);
        ScaStatus scaStatus = ScaStatus.STARTED;
        String authorisationId = UUID.randomUUID().toString();
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        StartAuthorisationsParameters startAuthorisationsParameters = StartAuthorisationsParameters.builder().psuData(psuIdData).businessObjectId(consentId).scaStatus(scaStatus).authorisationId(authorisationId).build();
        Authorisation authorisation = new Authorisation(authorisationId, psuIdData, consentId, AuthorisationType.CONSENT, scaStatus);
        AisAuthorisationProcessorRequest processorRequest = new AisAuthorisationProcessorRequest(scaApproach, scaStatus, startAuthorisationsParameters, authorisation);
        CreateConsentAuthorisationProcessorResponse processorResponse = (CreateConsentAuthorisationProcessorResponse)this.authorisationChainResponsibilityService.apply(processorRequest);
        Xs2aCreateAuthorisationRequest createAuthorisationRequest = Xs2aCreateAuthorisationRequest.builder().psuData(psuIdData).consentId(consentId).authorisationId(authorisationId).scaStatus(processorResponse.getScaStatus()).scaApproach(processorResponse.getScaApproach()).build();
        ConsentAuthorizationService service = (ConsentAuthorizationService)this.aisScaAuthorisationServiceResolver.getService();
        Optional<CreateConsentAuthorizationResponse> consentAuthorizationResponse = service.createConsentAuthorization(createAuthorisationRequest);
        if (consentAuthorizationResponse.isEmpty()) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        CreateConsentAuthorizationResponse createConsentAuthorizationResponse = consentAuthorizationResponse.get();
        this.setPsuMessageAndTppMessages(createConsentAuthorizationResponse, processorResponse.getPsuMessage(), processorResponse.getTppMessages());
        return ResponseObject.builder().body(createConsentAuthorizationResponse).build();
    }

    private void setPsuMessageAndTppMessages(AuthorisationResponse response, String psuMessage, Set<TppMessageInformation> tppMessageInformationSet) {
        if (psuMessage != null) {
            response.setPsuMessage(psuMessage);
        }
        if (tppMessageInformationSet != null) {
            response.getTppMessageInformation().addAll(tppMessageInformationSet);
        }
    }

    private PsuIdData getActualPsuData(PsuIdData psuDataFromRequest, AisConsent aisConsent) {
        boolean isMultilevel = aisConsent.isMultilevelScaRequired();
        if (psuDataFromRequest.isNotEmpty() || isMultilevel) {
            return psuDataFromRequest;
        }
        return aisConsent.getPsuIdDataList().stream().findFirst().orElse(psuDataFromRequest);
    }

    private Optional<Xs2aAuthorisationSubResources> getAuthorisationSubResources(String consentId) {
        return this.aisConsentService.getAuthorisationSubResources(consentId).map(Xs2aAuthorisationSubResources::new);
    }

    @ConstructorProperties(value={"xs2aAuthorisationService", "aisConsentService", "aisScaAuthorisationServiceResolver", "endpointAccessCheckerService", "xs2aEventService", "consentValidationService", "authorisationChainResponsibilityService", "loggingContextService", "aisAuthorisationConfirmationService", "psuIdDataAuthorisationService", "eventTypeService", "scaApproachResolver"})
    public ConsentAuthorisationService(Xs2aAuthorisationService xs2aAuthorisationService, Xs2aAisConsentService aisConsentService, AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver, ConsentEndpointAccessCheckerService endpointAccessCheckerService, Xs2aEventService xs2aEventService, ConsentValidationService consentValidationService, AuthorisationChainResponsibilityService authorisationChainResponsibilityService, LoggingContextService loggingContextService, AisAuthorisationConfirmationService aisAuthorisationConfirmationService, PsuIdDataAuthorisationService psuIdDataAuthorisationService, EventTypeService eventTypeService, ScaApproachResolver scaApproachResolver) {
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.aisConsentService = aisConsentService;
        this.aisScaAuthorisationServiceResolver = aisScaAuthorisationServiceResolver;
        this.endpointAccessCheckerService = endpointAccessCheckerService;
        this.xs2aEventService = xs2aEventService;
        this.consentValidationService = consentValidationService;
        this.authorisationChainResponsibilityService = authorisationChainResponsibilityService;
        this.loggingContextService = loggingContextService;
        this.aisAuthorisationConfirmationService = aisAuthorisationConfirmationService;
        this.psuIdDataAuthorisationService = psuIdDataAuthorisationService;
        this.eventTypeService = eventTypeService;
        this.scaApproachResolver = scaApproachResolver;
    }
}

