package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.AdditionalInformationStructured;
import de.adorsys.psd2.model.EntryDetailsElement;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.MonthsOfExecution;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.model.RemittanceInformationUnstructuredArray;
import de.adorsys.psd2.model.StandingOrderDetails;
import de.adorsys.psd2.model.Transactions;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.domain.EntryDetails;
import de.adorsys.psd2.xs2a.domain.TransactionInfo;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.domain.account.Xs2aStandingOrderDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.web.mapper.BalanceMapper;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-08-26T07:09:52+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class TransactionModelMapperImpl extends TransactionModelMapper {

    @Autowired
    private AmountModelMapper amountModelMapper;
    @Autowired
    private PurposeCodeMapper purposeCodeMapper;
    @Autowired
    private ReportExchangeMapper reportExchangeMapper;
    @Autowired
    private BalanceMapper balanceMapper;

    @Override
    public AccountReport mapToAccountReport(Xs2aAccountReport accountReport) {
        if ( accountReport == null ) {
            return null;
        }

        AccountReport accountReport1 = new AccountReport();

        accountReport1.setBooked( mapToTransactionList( accountReport.getBooked() ) );
        accountReport1.setPending( mapToTransactionList( accountReport.getPending() ) );
        accountReport1.setInformation( mapToTransactionList( accountReport.getInformation() ) );

        accountReport1.setLinks( hrefLinkMapper.mapToLinksMap(accountReport.getLinks()) );

        return accountReport1;
    }

    @Override
    public TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport transactionsReport) {
        if ( transactionsReport == null ) {
            return null;
        }

        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();

        transactionsResponse200Json.setTransactions( mapToAccountReport( transactionsReport.getAccountReport() ) );
        transactionsResponse200Json.setAccount( accountReferenceToAccountReference( transactionsReport.getAccountReference() ) );
        transactionsResponse200Json.setBalances( balanceMapper.mapToBalanceList( transactionsReport.getBalances() ) );

        transactionsResponse200Json.setLinks( hrefLinkMapper.mapToLinksMap(transactionsReport.getLinks()) );

        return transactionsResponse200Json;
    }

    @Override
    public Transactions mapToTransactions(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }

        Transactions transactions1 = new Transactions();

        transactions1.setBankTransactionCode( transactionsBankTransactionCodeCodeCode( transactions ) );
        transactions1.setTransactionAmount( amountModelMapper.mapToAmount( transactions.getAmount() ) );
        transactions1.setCreditorName( transactionsTransactionInfoCreditorName( transactions ) );
        transactions1.setCreditorAccount( accountReferenceToAccountReference( transactionsTransactionInfoCreditorAccount( transactions ) ) );
        transactions1.setCreditorAgent( transactionsTransactionInfoCreditorAgent( transactions ) );
        transactions1.setUltimateCreditor( transactionsTransactionInfoUltimateCreditor( transactions ) );
        transactions1.setDebtorName( transactionsTransactionInfoDebtorName( transactions ) );
        transactions1.setDebtorAccount( accountReferenceToAccountReference( transactionsTransactionInfoDebtorAccount( transactions ) ) );
        transactions1.setDebtorAgent( transactionsTransactionInfoDebtorAgent( transactions ) );
        transactions1.setUltimateDebtor( transactionsTransactionInfoUltimateDebtor( transactions ) );
        transactions1.setRemittanceInformationUnstructured( transactionsTransactionInfoRemittanceInformationUnstructured( transactions ) );
        List<String> remittanceInformationUnstructuredArray = transactionsTransactionInfoRemittanceInformationUnstructuredArray( transactions );
        transactions1.setRemittanceInformationUnstructuredArray( stringListToRemittanceInformationUnstructuredArray( remittanceInformationUnstructuredArray ) );
        transactions1.setRemittanceInformationStructured( transactionsTransactionInfoRemittanceInformationStructured( transactions ) );
        List<String> remittanceInformationStructuredArray = transactionsTransactionInfoRemittanceInformationStructuredArray( transactions );
        transactions1.setRemittanceInformationStructuredArray( stringListToRemittanceInformationStructuredArray( remittanceInformationStructuredArray ) );
        transactions1.setPurposeCode( purposeCodeMapper.mapToPurposeCode( transactionsTransactionInfoPurposeCode( transactions ) ) );
        transactions1.setTransactionId( transactions.getTransactionId() );
        transactions1.setEntryReference( transactions.getEntryReference() );
        transactions1.setEndToEndId( transactions.getEndToEndId() );
        transactions1.setBatchIndicator( transactions.getBatchIndicator() );
        transactions1.setBatchNumberOfTransactions( transactions.getBatchNumberOfTransactions() );
        transactions1.setMandateId( transactions.getMandateId() );
        transactions1.setCheckId( transactions.getCheckId() );
        transactions1.setCreditorId( transactions.getCreditorId() );
        transactions1.setBookingDate( transactions.getBookingDate() );
        transactions1.setValueDate( transactions.getValueDate() );
        transactions1.setEntryDetails( entryDetailsListToEntryDetails( transactions.getEntryDetails() ) );
        transactions1.setAdditionalInformation( transactions.getAdditionalInformation() );
        transactions1.setAdditionalInformationStructured( xs2aAdditionalInformationStructuredToAdditionalInformationStructured( transactions.getAdditionalInformationStructured() ) );
        transactions1.setProprietaryBankTransactionCode( transactions.getProprietaryBankTransactionCode() );
        transactions1.setBalanceAfterTransaction( balanceMapper.mapToBalance( transactions.getBalanceAfterTransaction() ) );

        transactions1.setCurrencyExchange( reportExchangeMapper.mapToReportExchanges(transactions.getExchangeRate()) );

        return transactions1;
    }

    @Override
    public EntryDetailsElement mapToEntryDetailsElement(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }

        EntryDetailsElement entryDetailsElement = new EntryDetailsElement();

        entryDetailsElement.setCreditorName( entryDetailsTransactionInfoCreditorName( entryDetails ) );
        entryDetailsElement.setCreditorAccount( accountReferenceToAccountReference( entryDetailsTransactionInfoCreditorAccount( entryDetails ) ) );
        entryDetailsElement.setCreditorAgent( entryDetailsTransactionInfoCreditorAgent( entryDetails ) );
        entryDetailsElement.setUltimateCreditor( entryDetailsTransactionInfoUltimateCreditor( entryDetails ) );
        entryDetailsElement.setDebtorName( entryDetailsTransactionInfoDebtorName( entryDetails ) );
        entryDetailsElement.setDebtorAccount( accountReferenceToAccountReference( entryDetailsTransactionInfoDebtorAccount( entryDetails ) ) );
        entryDetailsElement.setDebtorAgent( entryDetailsTransactionInfoDebtorAgent( entryDetails ) );
        entryDetailsElement.setUltimateDebtor( entryDetailsTransactionInfoUltimateDebtor( entryDetails ) );
        entryDetailsElement.setRemittanceInformationUnstructured( entryDetailsTransactionInfoRemittanceInformationUnstructured( entryDetails ) );
        List<String> remittanceInformationUnstructuredArray = entryDetailsTransactionInfoRemittanceInformationUnstructuredArray( entryDetails );
        entryDetailsElement.setRemittanceInformationUnstructuredArray( stringListToRemittanceInformationUnstructuredArray( remittanceInformationUnstructuredArray ) );
        entryDetailsElement.setRemittanceInformationStructured( entryDetailsTransactionInfoRemittanceInformationStructured( entryDetails ) );
        List<String> remittanceInformationStructuredArray = entryDetailsTransactionInfoRemittanceInformationStructuredArray( entryDetails );
        entryDetailsElement.setRemittanceInformationStructuredArray( stringListToRemittanceInformationStructuredArray( remittanceInformationStructuredArray ) );
        entryDetailsElement.setPurposeCode( purposeCodeMapper.mapToPurposeCode( entryDetailsTransactionInfoPurposeCode( entryDetails ) ) );
        entryDetailsElement.setEndToEndId( entryDetails.getEndToEndId() );
        entryDetailsElement.setMandateId( entryDetails.getMandateId() );
        entryDetailsElement.setCheckId( entryDetails.getCheckId() );
        entryDetailsElement.setCreditorId( entryDetails.getCreditorId() );
        entryDetailsElement.setTransactionAmount( amountModelMapper.mapToAmount( entryDetails.getTransactionAmount() ) );
        entryDetailsElement.setCurrencyExchange( reportExchangeMapper.mapToReportExchanges( entryDetails.getCurrencyExchange() ) );

        return entryDetailsElement;
    }

    protected AccountReference accountReferenceToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReference accountReference1 = new AccountReference();

        accountReference1.setIban( accountReference.getIban() );
        accountReference1.setBban( accountReference.getBban() );
        accountReference1.setPan( accountReference.getPan() );
        accountReference1.setMaskedPan( accountReference.getMaskedPan() );
        accountReference1.setMsisdn( accountReference.getMsisdn() );
        if ( accountReference.getCurrency() != null ) {
            accountReference1.setCurrency( accountReference.getCurrency().getCurrencyCode() );
        }
        accountReference1.setOtherAccountIdentification( accountReference.getOtherAccountIdentification() );

        return accountReference1;
    }

    private String transactionsBankTransactionCodeCodeCode(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        BankTransactionCode bankTransactionCodeCode = transactions.getBankTransactionCodeCode();
        if ( bankTransactionCodeCode == null ) {
            return null;
        }
        String code = bankTransactionCodeCode.getCode();
        if ( code == null ) {
            return null;
        }
        return code;
    }

    private String transactionsTransactionInfoCreditorName(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String creditorName = transactionInfo.getCreditorName();
        if ( creditorName == null ) {
            return null;
        }
        return creditorName;
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference transactionsTransactionInfoCreditorAccount(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        de.adorsys.psd2.xs2a.core.profile.AccountReference creditorAccount = transactionInfo.getCreditorAccount();
        if ( creditorAccount == null ) {
            return null;
        }
        return creditorAccount;
    }

    private String transactionsTransactionInfoCreditorAgent(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String creditorAgent = transactionInfo.getCreditorAgent();
        if ( creditorAgent == null ) {
            return null;
        }
        return creditorAgent;
    }

    private String transactionsTransactionInfoUltimateCreditor(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String ultimateCreditor = transactionInfo.getUltimateCreditor();
        if ( ultimateCreditor == null ) {
            return null;
        }
        return ultimateCreditor;
    }

    private String transactionsTransactionInfoDebtorName(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String debtorName = transactionInfo.getDebtorName();
        if ( debtorName == null ) {
            return null;
        }
        return debtorName;
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference transactionsTransactionInfoDebtorAccount(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        de.adorsys.psd2.xs2a.core.profile.AccountReference debtorAccount = transactionInfo.getDebtorAccount();
        if ( debtorAccount == null ) {
            return null;
        }
        return debtorAccount;
    }

    private String transactionsTransactionInfoDebtorAgent(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String debtorAgent = transactionInfo.getDebtorAgent();
        if ( debtorAgent == null ) {
            return null;
        }
        return debtorAgent;
    }

    private String transactionsTransactionInfoUltimateDebtor(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String ultimateDebtor = transactionInfo.getUltimateDebtor();
        if ( ultimateDebtor == null ) {
            return null;
        }
        return ultimateDebtor;
    }

    private String transactionsTransactionInfoRemittanceInformationUnstructured(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String remittanceInformationUnstructured = transactionInfo.getRemittanceInformationUnstructured();
        if ( remittanceInformationUnstructured == null ) {
            return null;
        }
        return remittanceInformationUnstructured;
    }

    private List<String> transactionsTransactionInfoRemittanceInformationUnstructuredArray(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        List<String> remittanceInformationUnstructuredArray = transactionInfo.getRemittanceInformationUnstructuredArray();
        if ( remittanceInformationUnstructuredArray == null ) {
            return null;
        }
        return remittanceInformationUnstructuredArray;
    }

    protected RemittanceInformationUnstructuredArray stringListToRemittanceInformationUnstructuredArray(List<String> list) {
        if ( list == null ) {
            return null;
        }

        RemittanceInformationUnstructuredArray remittanceInformationUnstructuredArray = new RemittanceInformationUnstructuredArray();
        for ( String string : list ) {
            remittanceInformationUnstructuredArray.add( string );
        }

        return remittanceInformationUnstructuredArray;
    }

    private String transactionsTransactionInfoRemittanceInformationStructured(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String remittanceInformationStructured = transactionInfo.getRemittanceInformationStructured();
        if ( remittanceInformationStructured == null ) {
            return null;
        }
        return remittanceInformationStructured;
    }

    private List<String> transactionsTransactionInfoRemittanceInformationStructuredArray(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        List<String> remittanceInformationStructuredArray = transactionInfo.getRemittanceInformationStructuredArray();
        if ( remittanceInformationStructuredArray == null ) {
            return null;
        }
        return remittanceInformationStructuredArray;
    }

    protected RemittanceInformationStructuredArray stringListToRemittanceInformationStructuredArray(List<String> list) {
        if ( list == null ) {
            return null;
        }

        RemittanceInformationStructuredArray remittanceInformationStructuredArray = new RemittanceInformationStructuredArray();
        for ( String string : list ) {
            remittanceInformationStructuredArray.add( string );
        }

        return remittanceInformationStructuredArray;
    }

    private PurposeCode transactionsTransactionInfoPurposeCode(de.adorsys.psd2.xs2a.domain.Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        PurposeCode purposeCode = transactionInfo.getPurposeCode();
        if ( purposeCode == null ) {
            return null;
        }
        return purposeCode;
    }

    protected de.adorsys.psd2.model.EntryDetails entryDetailsListToEntryDetails(List<EntryDetails> list) {
        if ( list == null ) {
            return null;
        }

        de.adorsys.psd2.model.EntryDetails entryDetails1 = new de.adorsys.psd2.model.EntryDetails();
        for ( EntryDetails entryDetails : list ) {
            entryDetails1.add( mapToEntryDetailsElement( entryDetails ) );
        }

        return entryDetails1;
    }

    protected FrequencyCode frequencyCodeToFrequencyCode(de.adorsys.psd2.xs2a.core.pis.FrequencyCode frequencyCode) {
        if ( frequencyCode == null ) {
            return null;
        }

        FrequencyCode frequencyCode1;

        switch ( frequencyCode ) {
            case DAILY: frequencyCode1 = FrequencyCode.DAILY;
            break;
            case WEEKLY: frequencyCode1 = FrequencyCode.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCode1 = FrequencyCode.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCode1 = FrequencyCode.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCode1 = FrequencyCode.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCode1 = FrequencyCode.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCode1 = FrequencyCode.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCode1 = FrequencyCode.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCode1 = FrequencyCode.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCode );
        }

        return frequencyCode1;
    }

    protected ExecutionRule pisExecutionRuleToExecutionRule(PisExecutionRule pisExecutionRule) {
        if ( pisExecutionRule == null ) {
            return null;
        }

        ExecutionRule executionRule;

        switch ( pisExecutionRule ) {
            case FOLLOWING: executionRule = ExecutionRule.FOLLOWING;
            break;
            case PRECEDING: executionRule = ExecutionRule.PRECEDING;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + pisExecutionRule );
        }

        return executionRule;
    }

    protected MonthsOfExecution stringListToMonthsOfExecution(List<String> list) {
        if ( list == null ) {
            return null;
        }

        MonthsOfExecution monthsOfExecution = new MonthsOfExecution();
        for ( String string : list ) {
            monthsOfExecution.add( string );
        }

        return monthsOfExecution;
    }

    protected StandingOrderDetails xs2aStandingOrderDetailsToStandingOrderDetails(Xs2aStandingOrderDetails xs2aStandingOrderDetails) {
        if ( xs2aStandingOrderDetails == null ) {
            return null;
        }

        StandingOrderDetails standingOrderDetails = new StandingOrderDetails();

        standingOrderDetails.setStartDate( xs2aStandingOrderDetails.getStartDate() );
        standingOrderDetails.setFrequency( frequencyCodeToFrequencyCode( xs2aStandingOrderDetails.getFrequency() ) );
        standingOrderDetails.setEndDate( xs2aStandingOrderDetails.getEndDate() );
        standingOrderDetails.setExecutionRule( pisExecutionRuleToExecutionRule( xs2aStandingOrderDetails.getExecutionRule() ) );
        standingOrderDetails.setWithinAMonthFlag( xs2aStandingOrderDetails.getWithinAMonthFlag() );
        standingOrderDetails.setMonthsOfExecution( stringListToMonthsOfExecution( xs2aStandingOrderDetails.getMonthsOfExecution() ) );
        standingOrderDetails.setMultiplicator( xs2aStandingOrderDetails.getMultiplicator() );
        standingOrderDetails.setLimitAmount( amountModelMapper.mapToAmount( xs2aStandingOrderDetails.getLimitAmount() ) );

        standingOrderDetails.setDayOfExecution( dayOfExecutionMapper.mapDayOfExecution(xs2aStandingOrderDetails.getDayOfExecution()) );

        return standingOrderDetails;
    }

    protected AdditionalInformationStructured xs2aAdditionalInformationStructuredToAdditionalInformationStructured(Xs2aAdditionalInformationStructured xs2aAdditionalInformationStructured) {
        if ( xs2aAdditionalInformationStructured == null ) {
            return null;
        }

        AdditionalInformationStructured additionalInformationStructured = new AdditionalInformationStructured();

        additionalInformationStructured.setStandingOrderDetails( xs2aStandingOrderDetailsToStandingOrderDetails( xs2aAdditionalInformationStructured.getStandingOrderDetails() ) );

        return additionalInformationStructured;
    }

    private String entryDetailsTransactionInfoCreditorName(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String creditorName = transactionInfo.getCreditorName();
        if ( creditorName == null ) {
            return null;
        }
        return creditorName;
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference entryDetailsTransactionInfoCreditorAccount(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        de.adorsys.psd2.xs2a.core.profile.AccountReference creditorAccount = transactionInfo.getCreditorAccount();
        if ( creditorAccount == null ) {
            return null;
        }
        return creditorAccount;
    }

    private String entryDetailsTransactionInfoCreditorAgent(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String creditorAgent = transactionInfo.getCreditorAgent();
        if ( creditorAgent == null ) {
            return null;
        }
        return creditorAgent;
    }

    private String entryDetailsTransactionInfoUltimateCreditor(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String ultimateCreditor = transactionInfo.getUltimateCreditor();
        if ( ultimateCreditor == null ) {
            return null;
        }
        return ultimateCreditor;
    }

    private String entryDetailsTransactionInfoDebtorName(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String debtorName = transactionInfo.getDebtorName();
        if ( debtorName == null ) {
            return null;
        }
        return debtorName;
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference entryDetailsTransactionInfoDebtorAccount(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        de.adorsys.psd2.xs2a.core.profile.AccountReference debtorAccount = transactionInfo.getDebtorAccount();
        if ( debtorAccount == null ) {
            return null;
        }
        return debtorAccount;
    }

    private String entryDetailsTransactionInfoDebtorAgent(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String debtorAgent = transactionInfo.getDebtorAgent();
        if ( debtorAgent == null ) {
            return null;
        }
        return debtorAgent;
    }

    private String entryDetailsTransactionInfoUltimateDebtor(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String ultimateDebtor = transactionInfo.getUltimateDebtor();
        if ( ultimateDebtor == null ) {
            return null;
        }
        return ultimateDebtor;
    }

    private String entryDetailsTransactionInfoRemittanceInformationUnstructured(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String remittanceInformationUnstructured = transactionInfo.getRemittanceInformationUnstructured();
        if ( remittanceInformationUnstructured == null ) {
            return null;
        }
        return remittanceInformationUnstructured;
    }

    private List<String> entryDetailsTransactionInfoRemittanceInformationUnstructuredArray(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        List<String> remittanceInformationUnstructuredArray = transactionInfo.getRemittanceInformationUnstructuredArray();
        if ( remittanceInformationUnstructuredArray == null ) {
            return null;
        }
        return remittanceInformationUnstructuredArray;
    }

    private String entryDetailsTransactionInfoRemittanceInformationStructured(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        String remittanceInformationStructured = transactionInfo.getRemittanceInformationStructured();
        if ( remittanceInformationStructured == null ) {
            return null;
        }
        return remittanceInformationStructured;
    }

    private List<String> entryDetailsTransactionInfoRemittanceInformationStructuredArray(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        List<String> remittanceInformationStructuredArray = transactionInfo.getRemittanceInformationStructuredArray();
        if ( remittanceInformationStructuredArray == null ) {
            return null;
        }
        return remittanceInformationStructuredArray;
    }

    private PurposeCode entryDetailsTransactionInfoPurposeCode(EntryDetails entryDetails) {
        if ( entryDetails == null ) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if ( transactionInfo == null ) {
            return null;
        }
        PurposeCode purposeCode = transactionInfo.getPurposeCode();
        if ( purposeCode == null ) {
            return null;
        }
        return purposeCode;
    }
}
