/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.NotificationSupportedMode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.header.AbstractHeaderValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.header.ConsentHeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.header.PaymentHeaderValidator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TppNotificationContentPreferredHeaderValidatorImpl
extends AbstractHeaderValidatorImpl
implements PaymentHeaderValidator,
ConsentHeaderValidator {
    @Autowired
    public TppNotificationContentPreferredHeaderValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getHeaderName() {
        return "tpp-notification-content-preferred";
    }

    @Override
    public ValidationResult validate(Map<String, String> headers) {
        String[] modes;
        String tppNotificationContentPreferredString = headers.get(this.getHeaderName());
        if (tppNotificationContentPreferredString == null) {
            return ValidationResult.valid();
        }
        for (String mode : modes = tppNotificationContentPreferredString.replace("status=", "").split(",")) {
            String trimmedMode = mode.trim();
            if (NotificationSupportedMode.getByValue((String)trimmedMode) != null) continue;
            return ValidationResult.invalid((ErrorType)this.errorBuildingService.buildErrorType(), (TppMessageInformation)TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_INVALID_NOTIFICATION_MODE, (Object[])new Object[]{trimmedMode}));
        }
        return ValidationResult.valid();
    }
}

