/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment;

import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.ChargeBearer;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.validator.payment.CountryPaymentValidatorResolver;
import de.adorsys.psd2.xs2a.web.PathParameterExtractor;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.CurrencyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.DateFieldValidator;
import de.adorsys.psd2.xs2a.web.validator.body.FieldLengthValidator;
import de.adorsys.psd2.xs2a.web.validator.body.TppRedirectUriBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.payment.PaymentBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.raw.FieldExtractor;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateFields;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements PaymentBodyValidator {
    private static final Logger log = LoggerFactory.getLogger(PaymentBodyValidatorImpl.class);
    private static final String PAYMENT_SERVICE_PATH_VAR = "payment-service";
    private static final String PAYMENT_PRODUCT_PATH_VAR = "payment-product";
    static final String PERIODIC_PAYMENT_PATH_VAR = "periodic-payments";
    static final String BULK_PAYMENT_PATH_VAR = "bulk-payments";
    static final String PURPOSE_CODE_FIELD_NAME = "purposeCode";
    static final String FREQUENCY_FIELD_NAME = "frequency";
    static final String CHARGE_BEARER_FIELD_NAME = "chargeBearer";
    static final String BATCH_BOOKING_PREFERRED_FIELD_NAME = "batchBookingPreferred";
    static final String CURRENCY_STRING = "currency";
    private DateFieldValidator dateFieldValidator;
    private CurrencyValidator currencyValidator;
    private TppRedirectUriBodyValidatorImpl tppRedirectUriBodyValidator;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final FieldExtractor fieldExtractor;
    private final PathParameterExtractor pathParameterExtractor;
    private CountryPaymentValidatorResolver countryPaymentValidatorResolver;

    @Autowired
    public PaymentBodyValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, StandardPaymentProductsResolver standardPaymentProductsResolver, TppRedirectUriBodyValidatorImpl tppRedirectUriBodyValidator, DateFieldValidator dateFieldValidator, FieldExtractor fieldExtractor, CurrencyValidator currencyValidator, PathParameterExtractor pathParameterExtractor, CountryPaymentValidatorResolver countryPaymentValidatorResolver, FieldLengthValidator fieldLengthValidator) {
        super(errorBuildingService, xs2aObjectMapper, fieldLengthValidator);
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.dateFieldValidator = dateFieldValidator;
        this.tppRedirectUriBodyValidator = tppRedirectUriBodyValidator;
        this.fieldExtractor = fieldExtractor;
        this.currencyValidator = currencyValidator;
        this.pathParameterExtractor = pathParameterExtractor;
        this.countryPaymentValidatorResolver = countryPaymentValidatorResolver;
    }

    @Override
    public MessageError validate(HttpServletRequest request, MessageError messageError) {
        if (this.isRawPaymentProduct(this.getPathParameters(request))) {
            log.info("Raw payment product is detected.");
            return messageError;
        }
        return super.validate(request, messageError);
    }

    @Override
    public MessageError validateBodyFields(HttpServletRequest request, MessageError messageError) {
        this.tppRedirectUriBodyValidator.validate(request, messageError);
        String paymentService = this.getPathParameters(request).get(PAYMENT_SERVICE_PATH_VAR);
        return this.countryPaymentValidatorResolver.getPaymentBodyFieldValidator().validate(request, paymentService, messageError);
    }

    @Override
    public MessageError validateRawData(HttpServletRequest request, MessageError messageError) {
        this.dateFieldValidator.validateDayOfExecution(request, messageError);
        this.dateFieldValidator.validateDateFormat(request, Xs2aRequestBodyDateFields.PAYMENT_DATE_FIELDS.getDateFields(), messageError);
        this.validateCurrency(request, messageError);
        this.validateBulkPaymentFields(request, messageError);
        this.validateFrequencyForPeriodicPayment(request, messageError);
        this.validatePurposeCodes(request, messageError);
        this.validateChargeBearerList(request, messageError);
        return messageError;
    }

    private void validateCurrency(HttpServletRequest request, MessageError messageError) {
        List<String> currencyList = this.getCurrencyOptionalString(request);
        if (!currencyList.isEmpty()) {
            currencyList.forEach(c -> this.currencyValidator.validateCurrency((String)c, messageError));
        }
    }

    private List<String> getCurrencyOptionalString(HttpServletRequest request) {
        return this.fieldExtractor.extractOptionalList(request, CURRENCY_STRING);
    }

    private void validateBulkPaymentFields(HttpServletRequest request, MessageError messageError) {
        boolean isBulkPayment = this.getPathParameters(request).get(PAYMENT_SERVICE_PATH_VAR).equals(BULK_PAYMENT_PATH_VAR);
        if (isBulkPayment) {
            this.validateBatchBookingPreferredField(request, messageError);
        }
    }

    private void validateBatchBookingPreferredField(HttpServletRequest request, MessageError messageError) {
        Optional<String> fieldValue = this.fieldExtractor.extractOptionalField(request, BATCH_BOOKING_PREFERRED_FIELD_NAME);
        if (fieldValue.isPresent()) {
            try {
                BooleanUtils.toBoolean((String)fieldValue.get(), (String)"true", (String)"false");
            }
            catch (IllegalArgumentException e) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_BOOLEAN_VALUE, (Object[])new Object[]{BATCH_BOOKING_PREFERRED_FIELD_NAME}));
            }
        }
    }

    private void validateFrequencyForPeriodicPayment(HttpServletRequest request, MessageError messageError) {
        Optional<String> frequencyOptional = this.fieldExtractor.extractField(request, FREQUENCY_FIELD_NAME, messageError);
        boolean isPeriodicPayment = this.getPathParameters(request).get(PAYMENT_SERVICE_PATH_VAR).equals(PERIODIC_PAYMENT_PATH_VAR);
        if (isPeriodicPayment) {
            if (frequencyOptional.isEmpty()) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{FREQUENCY_FIELD_NAME}));
            } else if (FrequencyCode.fromValue((String)frequencyOptional.get()) == null) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{FREQUENCY_FIELD_NAME}));
            }
        }
    }

    private void validateChargeBearerList(HttpServletRequest request, MessageError messageError) {
        List<String> chargeBearerList = this.getChargeBearerOptionalString(request);
        if (!chargeBearerList.isEmpty()) {
            chargeBearerList.forEach(c -> this.validateChargeBearer(messageError, (String)c));
        }
    }

    private List<String> getChargeBearerOptionalString(HttpServletRequest request) {
        return this.fieldExtractor.extractOptionalList(request, CHARGE_BEARER_FIELD_NAME);
    }

    private void validateChargeBearer(MessageError messageError, String chargeBearer) {
        if (chargeBearer != null && ChargeBearer.fromValue((String)chargeBearer) == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{CHARGE_BEARER_FIELD_NAME}));
        }
    }

    private boolean isRawPaymentProduct(Map<String, String> pathParametersMap) {
        String paymentProduct = pathParametersMap.get(PAYMENT_PRODUCT_PATH_VAR);
        return this.standardPaymentProductsResolver.isRawPaymentProduct(paymentProduct);
    }

    private void validatePurposeCodes(HttpServletRequest request, MessageError messageError) {
        List<String> purposeCodes = this.fieldExtractor.extractList(request, PURPOSE_CODE_FIELD_NAME, messageError);
        boolean isPurposeCodeInvalid = purposeCodes.stream().map(PurposeCode::fromValue).anyMatch(Objects::isNull);
        if (isPurposeCodeInvalid) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{PURPOSE_CODE_FIELD_NAME}));
        }
    }

    private Map<String, String> getPathParameters(HttpServletRequest request) {
        return this.pathParameterExtractor.extractParameters(request);
    }
}

