/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import java.util.Currency;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CurrencyValidator {
    private static final String CURRENCY_STRING = "currency";
    private final ErrorBuildingService errorBuildingService;

    public void validateCurrency(String currency, MessageError messageError) {
        if (StringUtils.isEmpty((CharSequence)currency)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EMPTY_FIELD, (Object[])new Object[]{CURRENCY_STRING}));
        } else if (!this.isValidCurrency(currency)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{CURRENCY_STRING}));
        }
    }

    private boolean isValidCurrency(String currency) {
        try {
            Currency.getInstance(currency);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @ConstructorProperties(value={"errorBuildingService"})
    public CurrencyValidator(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }
}

