/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import de.adorsys.psd2.xs2a.web.link.holder.LinkParameters;
import java.util.EnumSet;

public class CreatePisAuthorisationLinks
extends AbstractLinks {
    public CreatePisAuthorisationLinks(LinkParameters linkParameters, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, Xs2aCreatePisAuthorisationRequest createRequest, ScaRedirectFlow scaRedirectFlow) {
        super(linkParameters.getHttpUrl());
        String paymentId = createRequest.getPaymentId();
        String paymentService = createRequest.getPaymentService().getValue();
        String paymentProduct = createRequest.getPaymentProduct();
        this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, linkParameters.getAuthorisationId()));
        ScaApproach initiationScaApproach = scaApproachResolver.getScaApproach(linkParameters.getAuthorisationId());
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(initiationScaApproach)) {
            String path = "/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}";
            this.setUpdatePsuAuthentication(this.buildPath(path, paymentService, paymentProduct, paymentId, linkParameters.getAuthorisationId()));
        } else if (initiationScaApproach == ScaApproach.REDIRECT) {
            String redirectId = redirectIdService.generateRedirectId(linkParameters.getAuthorisationId());
            String paymentOauthLink = scaRedirectFlow == ScaRedirectFlow.OAUTH ? redirectLinkBuilder.buildPaymentScaOauthRedirectLink(paymentId, redirectId, linkParameters.getInternalRequestId()) : redirectLinkBuilder.buildPaymentScaRedirectLink(paymentId, redirectId, linkParameters.getInternalRequestId(), linkParameters.getInstanceId());
            this.setScaRedirect(new HrefType(paymentOauthLink));
            if (linkParameters.isAuthorisationConfirmationRequestMandated()) {
                this.setConfirmation(this.buildPath(redirectLinkBuilder.buildPisConfirmationLink(paymentService, paymentProduct, paymentId, redirectId), new Object[0]));
            }
        }
    }
}

