/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aConfirmationOfFundsResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import de.adorsys.psd2.xs2a.web.link.holder.LinkParameters;
import java.util.EnumSet;

public class CreatePiisConsentLinks
extends AbstractLinks {
    public CreatePiisConsentLinks(LinkParameters linkParameters, ScaApproachResolver scaApproachResolver, Xs2aConfirmationOfFundsResponse response, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, ScaRedirectFlow scaRedirectFlow) {
        super(linkParameters.getHttpUrl());
        ScaApproach scaApproach;
        String consentId = response.getConsentId();
        this.setSelf(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}", consentId));
        this.setStatus(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/status", consentId));
        String authorisationId = response.getAuthorizationId();
        ScaApproach scaApproach2 = scaApproach = authorisationId == null ? scaApproachResolver.resolveScaApproach() : scaApproachResolver.getScaApproach(authorisationId);
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(scaApproach)) {
            this.buildLinkForEmbeddedAndDecoupledScaApproach(consentId, authorisationId, linkParameters.isExplicitMethod(), linkParameters.isSigningBasketModeActive());
        } else if (ScaApproach.REDIRECT == scaApproach) {
            if (linkParameters.isExplicitMethod()) {
                this.setStartAuthorisation(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations", consentId));
            } else {
                String redirectId = redirectIdService.generateRedirectId(authorisationId);
                String consentOauthLink = scaRedirectFlow == ScaRedirectFlow.OAUTH ? redirectLinkBuilder.buildConsentScaOauthRedirectLink(consentId, redirectId, response.getInternalRequestId()) : redirectLinkBuilder.buildConsentScaRedirectLink(consentId, redirectId, response.getInternalRequestId(), linkParameters.getInstanceId(), ConsentType.PIIS_TPP);
                this.setScaRedirect(new HrefType(consentOauthLink));
                this.setScaStatus(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
                if (linkParameters.isAuthorisationConfirmationRequestMandated()) {
                    this.setConfirmation(this.buildPath(redirectLinkBuilder.buildConfirmationLink(consentId, redirectId, ConsentType.PIIS_TPP), new Object[0]));
                }
            }
        }
    }

    private void buildLinkForEmbeddedAndDecoupledScaApproach(String consentId, String authorizationId, boolean explicitMethod, boolean signingBasketModeActive) {
        if (explicitMethod) {
            if (signingBasketModeActive) {
                this.setStartAuthorisation(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations", consentId));
            } else {
                this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations", consentId));
            }
        } else {
            this.setScaStatus(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
            this.setUpdatePsuAuthentication(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
        }
    }
}

