/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.validator;

import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.MethodValidator;
import de.adorsys.psd2.xs2a.web.validator.MethodValidatorController;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class RequestValidationInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(RequestValidationInterceptor.class);
    private final ErrorBuildingService errorBuildingService;
    private final MethodValidatorController methodValidatorController;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.isRequestValid(request, response, handler);
    }

    private boolean isRequestValid(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        HandlerMethod handlerMethod;
        String methodName;
        MethodValidator methodValidator;
        MessageError initialMessageError = new MessageError();
        if (handler instanceof HandlerMethod && !(initialMessageError = (methodValidator = this.methodValidatorController.getMethod(methodName = (handlerMethod = (HandlerMethod)handler).getMethod().getName())).validate(request, initialMessageError)).getTppMessages().isEmpty()) {
            log.warn("Validation of incoming request failed. Error msg: [{}]", (Object)initialMessageError);
            this.errorBuildingService.buildFormatErrorResponse(response, initialMessageError);
            return false;
        }
        return true;
    }

    @ConstructorProperties(value={"errorBuildingService", "methodValidatorController"})
    public RequestValidationInterceptor(ErrorBuildingService errorBuildingService, MethodValidatorController methodValidatorController) {
        this.errorBuildingService = errorBuildingService;
        this.methodValidatorController = methodValidatorController;
    }
}

