/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.web.Xs2aEndpointChecker;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageWriter;
import de.adorsys.psd2.xs2a.web.filter.AbstractXs2aFilter;
import de.adorsys.psd2.xs2a.web.filter.holder.QwacCertificateService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QwacCertificateFilter
extends AbstractXs2aFilter {
    private static final Logger log = LoggerFactory.getLogger(QwacCertificateFilter.class);
    private final QwacCertificateService qwacCertificateService;
    private final RequestProviderService requestProviderService;

    public QwacCertificateFilter(TppErrorMessageWriter tppErrorMessageWriter, Xs2aEndpointChecker xs2aEndpointChecker, QwacCertificateService qwacCertificateService, RequestProviderService requestProviderService) {
        super(tppErrorMessageWriter, xs2aEndpointChecker);
        this.qwacCertificateService = qwacCertificateService;
        this.requestProviderService = requestProviderService;
    }

    @Override
    protected void doFilterInternalCustom(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String encodedTppQwacCert = this.requestProviderService.getEncodedTppQwacCert();
        if (StringUtils.isNotBlank((CharSequence)encodedTppQwacCert) && !this.qwacCertificateService.isApplicable(request, response, encodedTppQwacCert)) {
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

