/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.PaymentApi;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse202;
import de.adorsys.psd2.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.AdditionalPsuIdData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppAttributes;
import de.adorsys.psd2.xs2a.core.tpp.TppNotificationData;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.NotificationModeResponseHeaders;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.authorisation.CancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.GetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.exception.WrongPaymentTypeException;
import de.adorsys.psd2.xs2a.service.NotificationSupportedModeService;
import de.adorsys.psd2.xs2a.service.PaymentAuthorisationService;
import de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService;
import de.adorsys.psd2.xs2a.service.PaymentCancellationServiceForAuthorisationImpl;
import de.adorsys.psd2.xs2a.service.PaymentService;
import de.adorsys.psd2.xs2a.service.PaymentServiceForAuthorisationImpl;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import de.adorsys.psd2.xs2a.web.header.PaymentCancellationHeadersBuilder;
import de.adorsys.psd2.xs2a.web.header.PaymentInitiationHeadersBuilder;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationMapper;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapperPsd2;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapperXs2a;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PaymentController
implements PaymentApi {
    private final PaymentService xs2aPaymentService;
    private final ResponseMapper responseMapper;
    private final ResponseErrorMapper responseErrorMapper;
    private final PaymentModelMapperPsd2 paymentModelMapperPsd2;
    private final PaymentModelMapperXs2a paymentModelMapperXs2a;
    private final ConsentModelMapper consentModelMapper;
    private final PaymentAuthorisationService paymentAuthorisationService;
    private final PaymentCancellationAuthorisationService paymentCancellationAuthorisationService;
    private final AuthorisationMapper authorisationMapper;
    private final PaymentInitiationHeadersBuilder paymentInitiationHeadersBuilder;
    private final PaymentCancellationHeadersBuilder paymentCancellationHeadersBuilder;
    private final AuthorisationModelMapper authorisationModelMapper;
    private final NotificationSupportedModeService notificationSupportedModeService;
    private final PaymentServiceForAuthorisationImpl paymentServiceForAuthorisation;
    private final PaymentCancellationServiceForAuthorisationImpl paymentCancellationServiceForAuthorisation;
    private final RequestProviderService requestProviderService;

    public ResponseEntity getPaymentInitiationStatus(String paymentService, String paymentProduct, String paymentId, UUID xRequestId, String digest, String signature, byte[] tppSignatureCertificate, String psuIpAddress, String psuIpPort, String psuAccept, String psuAcceptCharset, String psuAcceptEncoding, String psuAcceptLanguage, String psuUserAgent, String psuHttpMethod, UUID psuDeviceId, String psuGeoLocation) {
        ResponseObject<GetPaymentStatusResponse> serviceResponse = this.xs2aPaymentService.getPaymentStatusById(this.getPaymentType(paymentService), paymentProduct, paymentId);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        if (serviceResponse.getBody().isResponseContentTypeJson()) {
            return this.responseMapper.ok(serviceResponse, this.paymentModelMapperPsd2::mapToStatusResponseJson);
        }
        return this.responseMapper.ok(serviceResponse, this.paymentModelMapperPsd2::mapToStatusResponseRaw);
    }

    public ResponseEntity getPaymentInformation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<CommonPayment> serviceResponse = this.xs2aPaymentService.getPaymentById(this.getPaymentType(paymentService), paymentProduct, paymentId);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.paymentModelMapperPsd2::mapToGetPaymentResponse);
    }

    public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(Object body, UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, Boolean tpPRejectionNoFundsPreferred, String tppBrandLoggingInformation, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, new AdditionalPsuIdData(psUIPPort, psUUserAgent, psUGeoLocation, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUHttpMethod, psUDeviceID));
        TppNotificationData tppNotificationData = this.notificationSupportedModeService.getTppNotificationData(tpPNotificationContentPreferred, tpPNotificationURI);
        TppAttributes tppAttributes = new TppAttributes(tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), tppNotificationData, tppBrandLoggingInformation);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tppAttributes, psuData, this.requestProviderService.getInstanceId());
        ResponseObject<PaymentInitiationResponse> serviceResponse = this.xs2aPaymentService.createPayment(this.paymentModelMapperXs2a.mapToXs2aPayment(), paymentInitiationParameters);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        PaymentInitiationResponse serviceResponseBody = serviceResponse.getBody();
        ResponseHeaders responseHeaders = this.buildPaymentInitiationResponseHeaders(serviceResponseBody);
        return this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse(serviceResponseBody)).build(), responseHeaders);
    }

    public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, Object xmlSct, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonStandingorderType, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, Boolean tpPRejectionNoFundsPreferred, String tppBrandLoggingInformation, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, new AdditionalPsuIdData(psUIPPort, psUUserAgent, psUGeoLocation, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUHttpMethod, psUDeviceID));
        TppNotificationData tppNotificationData = this.notificationSupportedModeService.getTppNotificationData(tpPNotificationContentPreferred, tpPNotificationURI);
        TppAttributes tppAttributes = new TppAttributes(tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), tppNotificationData, tppBrandLoggingInformation);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tppAttributes, psuData, this.requestProviderService.getInstanceId());
        ResponseObject<PaymentInitiationResponse> serviceResponse = this.xs2aPaymentService.createPayment(this.paymentModelMapperXs2a.mapToXs2aRawPayment(paymentInitiationParameters, xmlSct, jsonStandingorderType), paymentInitiationParameters);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        PaymentInitiationResponse serviceResponseBody = serviceResponse.getBody();
        ResponseHeaders responseHeaders = this.buildPaymentInitiationResponseHeaders(serviceResponseBody);
        return this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse(serviceResponseBody)).build(), responseHeaders);
    }

    public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(String body, UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, Boolean tpPRejectionNoFundsPreferred, String tppBrandLoggingInformation, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, new AdditionalPsuIdData(psUIPPort, psUUserAgent, psUGeoLocation, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUHttpMethod, psUDeviceID));
        TppNotificationData tppNotificationData = this.notificationSupportedModeService.getTppNotificationData(tpPNotificationContentPreferred, tpPNotificationURI);
        TppAttributes tppAttributes = new TppAttributes(tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), tppNotificationData, tppBrandLoggingInformation);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tppAttributes, psuData, this.requestProviderService.getInstanceId());
        ResponseObject<PaymentInitiationResponse> serviceResponse = this.xs2aPaymentService.createPayment(body.getBytes(), paymentInitiationParameters);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        PaymentInitiationResponse serviceResponseBody = serviceResponse.getBody();
        ResponseHeaders responseHeaders = this.buildPaymentInitiationResponseHeaders(serviceResponseBody);
        return this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse(serviceResponseBody)).build(), responseHeaders);
    }

    public ResponseEntity cancelPayment(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, Boolean tpPRedirectPreferred, String tpPNokRedirectURI, String tpPRedirectURI, Boolean tppExplicitAuthorisationPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PisPaymentCancellationRequest paymentCancellationRequest = this.paymentModelMapperPsd2.mapToPaymentCancellationRequest(paymentProduct, paymentService, paymentId, tppExplicitAuthorisationPreferred, tpPRedirectURI, tpPNokRedirectURI);
        ResponseObject<CancelPaymentResponse> serviceResponse = this.xs2aPaymentService.cancelPayment(paymentCancellationRequest);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        CancelPaymentResponse cancelPayment = serviceResponse.getBody();
        PaymentInitiationCancelResponse202 response = this.paymentModelMapperPsd2.mapToPaymentInitiationCancelResponse(cancelPayment);
        return cancelPayment.isStartAuthorisationRequired() ? this.responseMapper.accepted(ResponseObject.builder().body(response).build()) : this.responseMapper.delete(serviceResponse);
    }

    public ResponseEntity getPaymentCancellationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aScaStatusResponse> serviceResponse = this.paymentCancellationServiceForAuthorisation.getAuthorisationScaStatus(paymentId, authorisationId, this.getPaymentType(paymentService), paymentProduct);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity getPaymentInitiationAuthorisation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAuthorisationSubResources> serviceResponse = this.paymentAuthorisationService.getPaymentInitiationAuthorisations(paymentId, paymentProduct, this.getPaymentType(paymentService));
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToAuthorisations);
    }

    public ResponseEntity getPaymentInitiationCancellationAuthorisationInformation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aPaymentCancellationAuthorisationSubResource> serviceResponse = this.paymentCancellationAuthorisationService.getPaymentInitiationCancellationAuthorisationInformation(paymentId, this.getPaymentType(paymentService), paymentProduct);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.consentModelMapper::mapToAuthorisations);
    }

    public ResponseEntity getPaymentInitiationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aScaStatusResponse> serviceResponse = this.paymentServiceForAuthorisation.getAuthorisationScaStatus(paymentId, authorisationId, this.getPaymentType(paymentService), paymentProduct);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity startPaymentAuthorisation(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, Object body, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress);
        Xs2aCreatePisAuthorisationRequest createRequest = this.authorisationMapper.mapToXs2aCreatePisAuthorisationRequest(psuData, paymentId, this.getPaymentType(paymentService), paymentProduct, (Map)body);
        ResponseObject<AuthorisationResponse> createAuthResponse = this.paymentAuthorisationService.createPisAuthorisation(createRequest);
        if (createAuthResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(createAuthResponse.getError());
        }
        AuthorisationResponse authResponse = createAuthResponse.getBody();
        ResponseHeaders responseHeaders = this.paymentInitiationHeadersBuilder.buildStartAuthorisationHeaders(authResponse.getAuthorisationId());
        return this.responseMapper.created(ResponseObject.builder().body(this.authorisationMapper.mapToPisCreateOrUpdateAuthorisationResponse(createAuthResponse)).build(), responseHeaders);
    }

    public ResponseEntity startPaymentInitiationCancellationAuthorisation(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress);
        Xs2aCreatePisAuthorisationRequest createRequest = this.authorisationMapper.mapToXs2aCreatePisAuthorisationRequest(psuData, paymentId, this.getPaymentType(paymentService), paymentProduct, (Map)body);
        ResponseObject<CancellationAuthorisationResponse> serviceResponse = this.paymentCancellationAuthorisationService.createPisCancellationAuthorisation(createRequest);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        CancellationAuthorisationResponse serviceResponseBody = serviceResponse.getBody();
        ResponseHeaders responseHeaders = this.paymentCancellationHeadersBuilder.buildStartAuthorisationHeaders(serviceResponseBody.getAuthorisationId());
        return this.responseMapper.created(serviceResponse, this.authorisationModelMapper::mapToStartOrUpdateCancellationResponse, responseHeaders);
    }

    public ResponseEntity updatePaymentCancellationPsuData(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress);
        ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> serviceResponse = this.paymentCancellationAuthorisationService.updatePisCancellationPsuData(this.consentModelMapper.mapToPisUpdatePsuData(psuData, paymentId, authorisationId, this.getPaymentType(paymentService), paymentProduct, (Map)body));
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        ResponseHeaders responseHeaders = this.paymentCancellationHeadersBuilder.buildUpdatePsuDataHeaders(authorisationId);
        return this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToPisUpdatePsuAuthenticationResponse, responseHeaders);
    }

    public ResponseEntity updatePaymentPsuData(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress);
        return this.updatePisAuthorisation(psuData, authorisationId, paymentService, paymentProduct, paymentId, body);
    }

    private ResponseEntity<Object> updatePisAuthorisation(PsuIdData psuData, String authorisationId, String paymentService, String paymentProduct, String paymentId, Object body) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = this.consentModelMapper.mapToPisUpdatePsuData(psuData, paymentId, authorisationId, this.getPaymentType(paymentService), paymentProduct, (Map)body);
        ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> serviceResponse = this.paymentAuthorisationService.updatePisCommonPaymentPsuData(request);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        ResponseHeaders responseHeaders = this.paymentInitiationHeadersBuilder.buildUpdatePsuDataHeaders(authorisationId);
        return this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToPisUpdatePsuAuthenticationResponse, responseHeaders);
    }

    private ResponseHeaders buildPaymentInitiationResponseHeaders(PaymentInitiationResponse paymentInitiationResponse) {
        NotificationModeResponseHeaders notificationHeaders = this.notificationSupportedModeService.resolveNotificationHeaders(paymentInitiationResponse.getTppNotificationContentPreferred());
        String selfLink = Optional.ofNullable(paymentInitiationResponse.getLinks().getSelf()).map(HrefType::getHref).orElseThrow(() -> new IllegalArgumentException("Wrong href type in self link"));
        return this.paymentInitiationHeadersBuilder.buildInitiatePaymentHeaders(paymentInitiationResponse.getAuthorizationId(), selfLink, notificationHeaders);
    }

    private PaymentType getPaymentType(String paymentService) {
        return (PaymentType)PaymentType.getByValue((String)paymentService).orElseThrow(() -> new WrongPaymentTypeException(paymentService));
    }

    @ConstructorProperties(value={"xs2aPaymentService", "responseMapper", "responseErrorMapper", "paymentModelMapperPsd2", "paymentModelMapperXs2a", "consentModelMapper", "paymentAuthorisationService", "paymentCancellationAuthorisationService", "authorisationMapper", "paymentInitiationHeadersBuilder", "paymentCancellationHeadersBuilder", "authorisationModelMapper", "notificationSupportedModeService", "paymentServiceForAuthorisation", "paymentCancellationServiceForAuthorisation", "requestProviderService"})
    public PaymentController(PaymentService xs2aPaymentService, ResponseMapper responseMapper, ResponseErrorMapper responseErrorMapper, PaymentModelMapperPsd2 paymentModelMapperPsd2, PaymentModelMapperXs2a paymentModelMapperXs2a, ConsentModelMapper consentModelMapper, PaymentAuthorisationService paymentAuthorisationService, PaymentCancellationAuthorisationService paymentCancellationAuthorisationService, AuthorisationMapper authorisationMapper, PaymentInitiationHeadersBuilder paymentInitiationHeadersBuilder, PaymentCancellationHeadersBuilder paymentCancellationHeadersBuilder, AuthorisationModelMapper authorisationModelMapper, NotificationSupportedModeService notificationSupportedModeService, PaymentServiceForAuthorisationImpl paymentServiceForAuthorisation, PaymentCancellationServiceForAuthorisationImpl paymentCancellationServiceForAuthorisation, RequestProviderService requestProviderService) {
        this.xs2aPaymentService = xs2aPaymentService;
        this.responseMapper = responseMapper;
        this.responseErrorMapper = responseErrorMapper;
        this.paymentModelMapperPsd2 = paymentModelMapperPsd2;
        this.paymentModelMapperXs2a = paymentModelMapperXs2a;
        this.consentModelMapper = consentModelMapper;
        this.paymentAuthorisationService = paymentAuthorisationService;
        this.paymentCancellationAuthorisationService = paymentCancellationAuthorisationService;
        this.authorisationMapper = authorisationMapper;
        this.paymentInitiationHeadersBuilder = paymentInitiationHeadersBuilder;
        this.paymentCancellationHeadersBuilder = paymentCancellationHeadersBuilder;
        this.authorisationModelMapper = authorisationModelMapper;
        this.notificationSupportedModeService = notificationSupportedModeService;
        this.paymentServiceForAuthorisation = paymentServiceForAuthorisation;
        this.paymentCancellationServiceForAuthorisation = paymentCancellationServiceForAuthorisation;
        this.requestProviderService = requestProviderService;
    }
}

