/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.v2.ConfirmationOfFundsApi;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.model.ConsentsConfirmationOfFunds;
import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PiisConsentSupported;
import de.adorsys.psd2.xs2a.core.psu.AdditionalPsuIdData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aConfirmationOfFundsResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.PiisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.header.ConsentHeadersBuilder;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.PiisConsentModelMapper;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConfirmationOfFundsController
implements ConfirmationOfFundsApi {
    private static final Logger log = LoggerFactory.getLogger(ConfirmationOfFundsController.class);
    private final PiisConsentService piisConsentService;
    private final ResponseErrorMapper responseErrorMapper;
    private final PiisConsentModelMapper piisConsentModelMapper;
    private final ResponseMapper responseMapper;
    private final AspspProfileServiceWrapper profileService;
    private final ConsentHeadersBuilder consentHeadersBuilder;
    private final AuthorisationMapper authorisationMapper;
    private final ConsentModelMapper consentModelMapper;

    public ResponseEntity createConsentConfirmationOfFunds(UUID xRequestID, ConsentsConfirmationOfFunds body, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPExplicitAuthorisationPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (this.profileService.getPiisConsentSupported() != PiisConsentSupported.TPP_CONSENT_SUPPORTED) {
            MessageError messageError = new MessageError(ErrorType.PIIS_405, new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SERVICE_INVALID_405)});
            return this.responseErrorMapper.generateErrorResponse(messageError);
        }
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, new AdditionalPsuIdData(psUIPPort, psUUserAgent, psUGeoLocation, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUHttpMethod, psUDeviceID));
        CreatePiisConsentRequest createPiisConsentRequest = this.piisConsentModelMapper.toCreatePiisConsentRequest(body);
        ResponseObject<Xs2aConfirmationOfFundsResponse> xs2aConfirmationOfFundsResponseResponseObject = this.piisConsentService.createPiisConsentWithResponse(createPiisConsentRequest, psuData, BooleanUtils.toBoolean((String)tpPExplicitAuthorisationPreferred));
        if (xs2aConfirmationOfFundsResponseResponseObject.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(xs2aConfirmationOfFundsResponseResponseObject.getError());
        }
        Xs2aConfirmationOfFundsResponse xs2aConfirmationOfFundsResponse = xs2aConfirmationOfFundsResponseResponseObject.getBody();
        ResponseHeaders headers = this.consentHeadersBuilder.buildCreateConsentHeaders(xs2aConfirmationOfFundsResponse.getAuthorizationId(), Optional.ofNullable(xs2aConfirmationOfFundsResponse.getLinks().getSelf()).map(HrefType::getHref).orElseThrow(() -> new IllegalArgumentException("Wrong href type in self link")));
        return this.responseMapper.created(xs2aConfirmationOfFundsResponseResponseObject, this.piisConsentModelMapper::mapToConsentsConfirmationOfFundsResponse, headers);
    }

    public ResponseEntity deleteConsentConfirmationOfFunds(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Void> response = this.piisConsentService.deleteAccountConsentsById(consentId);
        return response.hasError() ? this.responseErrorMapper.generateErrorResponse(response.getError()) : this.responseMapper.delete(response);
    }

    public ResponseEntity getConsentConfirmationOfFunds(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<PiisConsent> piisConsentResponseObject = this.piisConsentService.getPiisConsentById(consentId);
        return piisConsentResponseObject.hasError() ? this.responseErrorMapper.generateErrorResponse(piisConsentResponseObject.getError()) : this.responseMapper.ok(piisConsentResponseObject, this.piisConsentModelMapper::mapToConsentConfirmationOfFundsContentResponse);
    }

    public ResponseEntity getConsentConfirmationOfFundsStatus(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<ConsentStatusResponse> accountConsentsStatusByIdResponse = this.piisConsentService.getPiisConsentStatusById(consentId);
        return accountConsentsStatusByIdResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(accountConsentsStatusByIdResponse.getError()) : this.responseMapper.ok(accountConsentsStatusByIdResponse, this.piisConsentModelMapper::mapToConsentConfirmationOfFundsStatusResponse);
    }

    public ResponseEntity getConsentAuthorisation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAuthorisationSubResources> consentInitiationAuthorisationsResponse = this.piisConsentService.getConsentInitiationAuthorisations(consentId);
        return consentInitiationAuthorisationsResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(consentInitiationAuthorisationsResponse.getError()) : this.responseMapper.ok(consentInitiationAuthorisationsResponse, this.authorisationMapper::mapToAuthorisations);
    }

    public ResponseEntity getConsentScaStatus(String consentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aScaStatusResponse> consentAuthorisationScaStatusResponse = this.piisConsentService.getConsentAuthorisationScaStatus(consentId, authorisationId);
        return consentAuthorisationScaStatusResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(consentAuthorisationScaStatusResponse.getError()) : this.responseMapper.ok(consentAuthorisationScaStatusResponse, this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity<StartScaprocessResponse> startConsentAuthorisation(UUID xRequestID, String consentId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        AdditionalPsuIdData additionalPsuIdData = new AdditionalPsuIdData(psUIPPort, psUUserAgent, psUGeoLocation, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUHttpMethod, psUDeviceID);
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, additionalPsuIdData);
        String password = this.authorisationMapper.mapToPasswordFromBody((Map)body);
        ResponseObject<AuthorisationResponse> createResponse = this.piisConsentService.createPiisAuthorisation(psuData, consentId, password);
        if (createResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(createResponse.getError());
        }
        AuthorisationResponse authorisationResponse = createResponse.getBody();
        ResponseHeaders responseHeaders = this.consentHeadersBuilder.buildStartAuthorisationHeaders(authorisationResponse.getAuthorisationId());
        return this.responseMapper.created(ResponseObject.builder().body(this.authorisationMapper.mapToConsentCreateOrUpdateAuthorisationResponse(createResponse)).build(), responseHeaders);
    }

    public ResponseEntity<Object> updateConsentsPsuData(UUID xRequestID, String consentId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress);
        return this.updatePiisAuthorisation(psuData, authorisationId, consentId, body);
    }

    private ResponseEntity<Object> updatePiisAuthorisation(PsuIdData psuData, String authorisationId, String consentId, Object body) {
        UpdateConsentPsuDataReq updatePsuDataRequest = this.consentModelMapper.mapToUpdatePsuData(psuData, consentId, authorisationId, (Map)body);
        ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuDataResponse = this.piisConsentService.updateConsentPsuData(updatePsuDataRequest);
        if (updateConsentPsuDataResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(updateConsentPsuDataResponse.getError());
        }
        ResponseHeaders responseHeaders = this.consentHeadersBuilder.buildUpdatePsuDataHeaders(authorisationId);
        return this.responseMapper.ok(updateConsentPsuDataResponse, this.authorisationMapper::mapToConsentUpdatePsuAuthenticationResponse, responseHeaders);
    }

    @ConstructorProperties(value={"piisConsentService", "responseErrorMapper", "piisConsentModelMapper", "responseMapper", "profileService", "consentHeadersBuilder", "authorisationMapper", "consentModelMapper"})
    public ConfirmationOfFundsController(PiisConsentService piisConsentService, ResponseErrorMapper responseErrorMapper, PiisConsentModelMapper piisConsentModelMapper, ResponseMapper responseMapper, AspspProfileServiceWrapper profileService, ConsentHeadersBuilder consentHeadersBuilder, AuthorisationMapper authorisationMapper, ConsentModelMapper consentModelMapper) {
        this.piisConsentService = piisConsentService;
        this.responseErrorMapper = responseErrorMapper;
        this.piisConsentModelMapper = piisConsentModelMapper;
        this.responseMapper = responseMapper;
        this.profileService = profileService;
        this.consentHeadersBuilder = consentHeadersBuilder;
        this.authorisationMapper = authorisationMapper;
        this.consentModelMapper = consentModelMapper;
    }
}

