/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.payment.raw;

import de.adorsys.psd2.validator.payment.PaymentBusinessValidator;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.service.validator.SupportedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.raw.PaymentAccountReferenceExtractor;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class DefaultPaymentBusinessValidatorImpl
implements PaymentBusinessValidator {
    private final PaymentAccountReferenceExtractor paymentAccountReferenceExtractor;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final SupportedAccountReferenceValidator supportedAccountReferenceValidator;

    public ValidationResult validate(byte[] body, String paymentProduct, PaymentType paymentType) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(paymentProduct)) {
            return ValidationResult.valid();
        }
        Set<AccountReference> accountReferences = this.paymentAccountReferenceExtractor.extractAccountReferences(body, paymentType);
        return this.supportedAccountReferenceValidator.validate((Collection<AccountReference>)accountReferences);
    }

    @ConstructorProperties(value={"paymentAccountReferenceExtractor", "standardPaymentProductsResolver", "supportedAccountReferenceValidator"})
    public DefaultPaymentBusinessValidatorImpl(PaymentAccountReferenceExtractor paymentAccountReferenceExtractor, StandardPaymentProductsResolver standardPaymentProductsResolver, SupportedAccountReferenceValidator supportedAccountReferenceValidator) {
        this.paymentAccountReferenceExtractor = paymentAccountReferenceExtractor;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.supportedAccountReferenceValidator = supportedAccountReferenceValidator;
    }
}

