/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.piis;

import de.adorsys.psd2.core.data.ConsentAutorizable;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.ConsentAuthorization;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationServiceType;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.service.validator.PiisPsuDataUpdateAuthorisationCheckerValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AbstractAisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationStageCheckValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.PiisAuthorisationStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.PiisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.dto.UpdatePiisConsentPsuDataRequestObject;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class UpdatePiisConsentPsuDataValidator
extends AbstractAisTppValidator<UpdatePiisConsentPsuDataRequestObject> {
    private final PiisAuthorisationValidator piisAuthorisationValidator;
    private final PiisPsuDataUpdateAuthorisationCheckerValidator piisPsuDataUpdateAuthorisationCheckerValidator;
    private final PiisAuthorisationStatusValidator piisAuthorisationStatusValidator;
    private final AuthorisationStageCheckValidator authorisationStageCheckValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(UpdatePiisConsentPsuDataRequestObject requestObject) {
        PiisConsent consent = requestObject.getPiisConsent();
        UpdateConsentPsuDataReq updatePsuData = requestObject.getUpdateRequest();
        String authorisationId = updatePsuData.getAuthorizationId();
        ValidationResult authorisationValidationResult = this.piisAuthorisationValidator.validate(authorisationId, (ConsentAutorizable)consent);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        Optional authorisationOptional = consent.findAuthorisationInConsent(authorisationId);
        if (authorisationOptional.isEmpty()) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIIS_403, (MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        ConsentAuthorization authorisation = (ConsentAuthorization)authorisationOptional.get();
        ValidationResult validationResult = this.piisPsuDataUpdateAuthorisationCheckerValidator.validate(updatePsuData.getPsuData(), authorisation.getPsuIdData());
        if (validationResult.isNotValid()) {
            return validationResult;
        }
        ValidationResult authorisationStatusValidationResult = this.piisAuthorisationStatusValidator.validate(authorisation.getScaStatus(), StringUtils.isNotBlank((CharSequence)updatePsuData.getConfirmationCode()));
        if (authorisationStatusValidationResult.isNotValid()) {
            return authorisationStatusValidationResult;
        }
        ValidationResult authorisationStageCheckValidatorResult = this.authorisationStageCheckValidator.validate(updatePsuData, authorisation.getScaStatus(), AuthorisationServiceType.PIIS);
        if (authorisationStageCheckValidatorResult.isNotValid()) {
            return authorisationStageCheckValidatorResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"piisAuthorisationValidator", "piisPsuDataUpdateAuthorisationCheckerValidator", "piisAuthorisationStatusValidator", "authorisationStageCheckValidator"})
    public UpdatePiisConsentPsuDataValidator(PiisAuthorisationValidator piisAuthorisationValidator, PiisPsuDataUpdateAuthorisationCheckerValidator piisPsuDataUpdateAuthorisationCheckerValidator, PiisAuthorisationStatusValidator piisAuthorisationStatusValidator, AuthorisationStageCheckValidator authorisationStageCheckValidator) {
        this.piisAuthorisationValidator = piisAuthorisationValidator;
        this.piisPsuDataUpdateAuthorisationCheckerValidator = piisPsuDataUpdateAuthorisationCheckerValidator;
        this.piisAuthorisationStatusValidator = piisAuthorisationStatusValidator;
        this.authorisationStageCheckValidator = authorisationStageCheckValidator;
    }
}

