/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.core.data.ConsentAutorizable;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.ConsentAuthorization;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationServiceType;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.service.validator.AisPsuDataUpdateAuthorisationCheckerValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AbstractAisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AisAuthorisationStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.UpdateConsentPsuDataRequestObject;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationStageCheckValidator;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class UpdateConsentPsuDataValidator
extends AbstractAisTppValidator<UpdateConsentPsuDataRequestObject> {
    private final AisAuthorisationValidator aisAuthorisationValidator;
    private final AisAuthorisationStatusValidator aisAuthorisationStatusValidator;
    private final AisPsuDataUpdateAuthorisationCheckerValidator aisPsuDataUpdateAuthorisationCheckerValidator;
    private final AuthorisationStageCheckValidator authorisationStageCheckValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(UpdateConsentPsuDataRequestObject requestObject) {
        AisConsent consent = requestObject.getAisConsent();
        UpdateConsentPsuDataReq updatePsuData = requestObject.getUpdateRequest();
        String authorisationId = updatePsuData.getAuthorizationId();
        ValidationResult authorisationValidationResult = this.aisAuthorisationValidator.validate(authorisationId, (ConsentAutorizable)consent);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        Optional authorisationOptional = consent.findAuthorisationInConsent(authorisationId);
        if (authorisationOptional.isEmpty()) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_403, (MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        ConsentAuthorization authorisation = (ConsentAuthorization)authorisationOptional.get();
        ValidationResult validationResult = this.aisPsuDataUpdateAuthorisationCheckerValidator.validate(updatePsuData.getPsuData(), authorisation.getPsuIdData());
        if (validationResult.isNotValid()) {
            return validationResult;
        }
        ValidationResult authorisationStatusValidationResult = this.aisAuthorisationStatusValidator.validate(authorisation.getScaStatus(), StringUtils.isNotBlank((CharSequence)updatePsuData.getConfirmationCode()));
        if (authorisationStatusValidationResult.isNotValid()) {
            return authorisationStatusValidationResult;
        }
        ValidationResult authorisationStageCheckValidatorResult = this.authorisationStageCheckValidator.validate(updatePsuData, authorisation.getScaStatus(), AuthorisationServiceType.AIS);
        if (authorisationStageCheckValidatorResult.isNotValid()) {
            return authorisationStageCheckValidatorResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"aisAuthorisationValidator", "aisAuthorisationStatusValidator", "aisPsuDataUpdateAuthorisationCheckerValidator", "authorisationStageCheckValidator"})
    public UpdateConsentPsuDataValidator(AisAuthorisationValidator aisAuthorisationValidator, AisAuthorisationStatusValidator aisAuthorisationStatusValidator, AisPsuDataUpdateAuthorisationCheckerValidator aisPsuDataUpdateAuthorisationCheckerValidator, AuthorisationStageCheckValidator authorisationStageCheckValidator) {
        this.aisAuthorisationValidator = aisAuthorisationValidator;
        this.aisAuthorisationStatusValidator = aisAuthorisationStatusValidator;
        this.aisPsuDataUpdateAuthorisationCheckerValidator = aisPsuDataUpdateAuthorisationCheckerValidator;
        this.authorisationStageCheckValidator = authorisationStageCheckValidator;
    }
}

