/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.core.data.ConsentAutorizable;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AbstractAisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationScaStatusPO;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetConsentAuthorisationScaStatusValidator
extends AbstractAisTppValidator<GetConsentAuthorisationScaStatusPO> {
    private final AisAuthorisationValidator aisAuthorisationValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetConsentAuthorisationScaStatusPO consentObject) {
        AisConsent response = consentObject.getAisConsent();
        String authorisationId = consentObject.getAuthorisationId();
        ValidationResult authorisationValidationResult = this.aisAuthorisationValidator.validate(authorisationId, (ConsentAutorizable)response);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        ValidationResult authAuthorisationValidationResult = this.oauthConsentValidator.validate(consentObject.getAisConsent());
        if (authAuthorisationValidationResult.isNotValid()) {
            return authAuthorisationValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"aisAuthorisationValidator", "oauthConsentValidator"})
    public GetConsentAuthorisationScaStatusValidator(AisAuthorisationValidator aisAuthorisationValidator, OauthConsentValidator oauthConsentValidator) {
        this.aisAuthorisationValidator = aisAuthorisationValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

