/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.TransactionReportAcceptHeaderValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CardTransactionsReportByPeriodObject;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetCardTransactionsReportValidator
extends AbstractAccountTppValidator<CardTransactionsReportByPeriodObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final TransactionReportAcceptHeaderValidator transactionReportAcceptHeaderValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CardTransactionsReportByPeriodObject requestObject) {
        AisConsent aisConsent = requestObject.getAisConsent();
        if (aisConsent.isConsentWithNotCardAccount() && !aisConsent.isConsentForAllAvailableAccounts() && !aisConsent.isGlobalConsent()) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_401, (MessageErrorCode)MessageErrorCode.CONSENT_INVALID);
        }
        ValidationResult acceptHeaderValidationResult = this.transactionReportAcceptHeaderValidator.validate(requestObject.getAcceptHeader());
        if (acceptHeaderValidationResult.isNotValid()) {
            return acceptHeaderValidationResult;
        }
        ValidationResult validationResult = this.validateCardTransactionReportParameters(requestObject.getDeltaList(), requestObject.getDateFrom());
        if (validationResult.isNotValid()) {
            return validationResult;
        }
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(aisConsent, requestObject.getTransactions(), requestObject.getAccountId(), aisConsent.getAisConsentRequestType());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        BookingStatus bookingStatus = requestObject.getBookingStatus();
        if (this.isNotSupportedBookingStatus(bookingStatus)) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_400, (TppMessageInformation)TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PARAMETER_NOT_SUPPORTED_BOOKING_STATUS, (Object[])new Object[]{bookingStatus.getValue()}));
        }
        ValidationResult oauthConsentValidationResult = this.oauthConsentValidator.validate(aisConsent);
        if (oauthConsentValidationResult.isNotValid()) {
            return oauthConsentValidationResult;
        }
        return this.accountConsentValidator.validate(aisConsent, requestObject.getRequestUri());
    }

    private ValidationResult validateCardTransactionReportParameters(Boolean deltaList, LocalDate dateFrom) {
        boolean isAllParametersPresentAndSupported;
        ArrayList<TppMessageInformation> tppMessageInformationList = new ArrayList<TppMessageInformation>();
        boolean isNotSearchByPeriod = dateFrom == null;
        boolean isDeltaListSupported = this.aspspProfileService.isDeltaListSupported();
        boolean isDeltaListPresentInRequest = BooleanUtils.isTrue((Boolean)deltaList);
        if (this.isDeltaAccessParameterNotSupported(isDeltaListSupported, isNotSearchByPeriod)) {
            tppMessageInformationList.add(TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PARAMETER_NOT_SUPPORTED_DELTA_LIST));
        }
        boolean bl = isAllParametersPresentAndSupported = isDeltaListSupported && isDeltaListPresentInRequest;
        if (isAllParametersPresentAndSupported) {
            tppMessageInformationList.add(TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_MULTIPLE_DELTA_REPORT));
        }
        return tppMessageInformationList.isEmpty() ? ValidationResult.valid() : ValidationResult.invalid((ErrorType)ErrorType.AIS_400, (TppMessageInformation[])tppMessageInformationList.toArray(new TppMessageInformation[0]));
    }

    private boolean isDeltaAccessParameterNotSupported(boolean isParameterSupportedInProfile, boolean isNotSearchByPeriod) {
        return !isParameterSupportedInProfile && isNotSearchByPeriod;
    }

    private boolean isNotSupportedBookingStatus(BookingStatus bookingStatus) {
        return !this.aspspProfileService.getAvailableBookingStatuses().contains(bookingStatus);
    }

    @ConstructorProperties(value={"accountConsentValidator", "aspspProfileService", "transactionReportAcceptHeaderValidator", "accountReferenceAccessValidator", "oauthConsentValidator"})
    public GetCardTransactionsReportValidator(AccountConsentValidator accountConsentValidator, AspspProfileServiceWrapper aspspProfileService, TransactionReportAcceptHeaderValidator transactionReportAcceptHeaderValidator, AccountReferenceAccessValidator accountReferenceAccessValidator, OauthConsentValidator oauthConsentValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.aspspProfileService = aspspProfileService;
        this.transactionReportAcceptHeaderValidator = transactionReportAcceptHeaderValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

