/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.consent.api.pis.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.OauthValidator;
import java.util.EnumSet;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class OauthPaymentValidator
extends OauthValidator<PisCommonPaymentResponse> {
    private static final MessageError MESSAGE_ERROR = new MessageError(ErrorType.PIS_403, new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORBIDDEN)});
    private static final Set<TransactionStatus> NOT_ALLOWED_STATUSES_FOR_GET_REQUESTS = EnumSet.of(TransactionStatus.RCVD, TransactionStatus.PDNG, TransactionStatus.PATC);

    public OauthPaymentValidator(RequestProviderService requestProviderService, AspspProfileServiceWrapper aspspProfileServiceWrapper, ScaApproachResolver scaApproachResolver) {
        super(requestProviderService, aspspProfileServiceWrapper, scaApproachResolver);
    }

    @Override
    protected boolean checkObjectForTokenAbsence(PisCommonPaymentResponse pisCommonPayment) {
        return !NOT_ALLOWED_STATUSES_FOR_GET_REQUESTS.contains(pisCommonPayment.getTransactionStatus());
    }

    @Override
    protected MessageError getMessageError() {
        return MESSAGE_ERROR;
    }
}

