/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.EndpointAccessChecker;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class ConsentEndpointAccessCheckerService
extends EndpointAccessChecker {
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final AspspProfileServiceWrapper aspspProfileService;

    public boolean isEndpointAccessible(String authorisationId, boolean confirmationCodeReceived) {
        boolean authorisationConfirmationRequestMandated = this.aspspProfileService.isAuthorisationConfirmationRequestMandated();
        if (this.aspspProfileService.getScaRedirectFlow() == ScaRedirectFlow.OAUTH && authorisationConfirmationRequestMandated) {
            return true;
        }
        boolean confirmationCodeCase = confirmationCodeReceived && authorisationConfirmationRequestMandated;
        return this.xs2aAuthorisationService.getAuthorisationById(authorisationId).map(a -> this.isAccessible(a.getChosenScaApproach(), a.getScaStatus(), confirmationCodeCase)).orElse(true);
    }

    @ConstructorProperties(value={"xs2aAuthorisationService", "aspspProfileService"})
    public ConsentEndpointAccessCheckerService(Xs2aAuthorisationService xs2aAuthorisationService, AspspProfileServiceWrapper aspspProfileService) {
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.aspspProfileService = aspspProfileService;
    }
}

