/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.pis.InternalPaymentStatus;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.CancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.PaymentCancellationAuthorisationNeededDecider;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCancelPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CancelPaymentService {
    private static final Logger log = LoggerFactory.getLogger(CancelPaymentService.class);
    private final PaymentCancellationSpi paymentCancellationSpi;
    private final Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService;
    private final PaymentCancellationAuthorisationNeededDecider cancellationScaNeededDecider;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final PaymentCancellationAuthorisationService paymentCancellationAuthorisationService;
    private final RequestProviderService requestProviderService;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    public ResponseObject<CancelPaymentResponse> initiatePaymentCancellation(SpiPayment payment, String encryptedPaymentId, Boolean tppExplicitAuthorisationPreferred, TppRedirectUri tppRedirectUri) {
        SpiAspspConsentDataProvider aspspConsentDataProvider;
        SpiContextData spiContextData = this.spiContextDataProvider.provide();
        SpiResponse spiResponse = this.paymentCancellationSpi.initiatePaymentCancellation(spiContextData, payment, aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("Payment-ID [{}]. Initiate Payment Cancellation has failed. Error msg: {}.", (Object)encryptedPaymentId, (Object)errorHolder);
            return ResponseObject.builder().fail(errorHolder).build();
        }
        CancelPaymentResponse cancelPaymentResponse = this.spiToXs2aCancelPaymentMapper.mapToCancelPaymentResponse((SpiPaymentCancellationResponse)spiResponse.getPayload(), payment, encryptedPaymentId);
        TransactionStatus resultStatus = cancelPaymentResponse.getTransactionStatus();
        if (resultStatus != null) {
            this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, resultStatus);
        } else {
            resultStatus = payment.getPaymentStatus();
            cancelPaymentResponse.setTransactionStatus(resultStatus);
        }
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        cancelPaymentResponse.setInternalRequestId(internalRequestId.toString());
        if (resultStatus == TransactionStatus.CANC) {
            log.info("Payment-ID [{}]. Initiate Payment Cancellation has failed. Payment status - CANCELED", (Object)encryptedPaymentId);
            this.updatePaymentStatusAfterSpiService.updateInternalPaymentStatus(encryptedPaymentId, InternalPaymentStatus.CANCELLED_FINALISED);
            return ResponseObject.builder().body(cancelPaymentResponse).build();
        }
        if (resultStatus.isFinalisedStatus()) {
            log.info("Payment-ID [{}]. Initiate Payment Cancellation has failed. Payment has finalised status", (Object)encryptedPaymentId);
            this.updatePaymentStatusAfterSpiService.updateInternalPaymentStatus(encryptedPaymentId, InternalPaymentStatus.FINALISED);
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_BLOCKED)).build();
        }
        if (resultStatus == TransactionStatus.RCVD || this.cancellationScaNeededDecider.isNoScaRequired(cancelPaymentResponse.isStartAuthorisationRequired())) {
            payment.setPaymentStatus(resultStatus);
            return this.proceedNoScaCancellation(payment, spiContextData, aspspConsentDataProvider, encryptedPaymentId);
        }
        boolean implicitMethod = this.authorisationMethodDecider.isImplicitMethod(tppExplicitAuthorisationPreferred, false);
        this.updatePaymentStatusAfterSpiService.updateInternalPaymentStatus(encryptedPaymentId, InternalPaymentStatus.CANCELLED_INITIATED);
        this.updatePaymentStatusAfterSpiService.updatePaymentCancellationTppRedirectUri(encryptedPaymentId, tppRedirectUri);
        this.updatePaymentStatusAfterSpiService.updatePaymentCancellationInternalRequestId(encryptedPaymentId, internalRequestId.toString());
        if (implicitMethod) {
            Xs2aCreatePisAuthorisationRequest request = new Xs2aCreatePisAuthorisationRequest(encryptedPaymentId, new PsuIdData(null, null, null, null, null), payment.getPaymentProduct(), payment.getPaymentType(), null);
            ResponseObject<CancellationAuthorisationResponse> authorisationResponse = this.paymentCancellationAuthorisationService.createPisCancellationAuthorisation(request);
            if (authorisationResponse.hasError()) {
                log.info("Payment-ID [{}]. Initiate Payment Cancellation has failed. Can't create implicit authorisation", (Object)encryptedPaymentId);
                return ResponseObject.builder().fail(ErrorType.PIS_CANC_405, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CANCELLATION_INVALID)).build();
            }
            CancellationAuthorisationResponse authorisationResponseBody = authorisationResponse.getBody();
            cancelPaymentResponse.setAuthorizationId(authorisationResponseBody.getAuthorisationId());
            cancelPaymentResponse.setScaStatus(authorisationResponseBody.getScaStatus());
        }
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    private ResponseObject<CancelPaymentResponse> proceedNoScaCancellation(SpiPayment payment, SpiContextData spiContextData, SpiAspspConsentDataProvider aspspConsentDataProvider, String encryptedPaymentId) {
        SpiResponse spiResponse = this.paymentCancellationSpi.cancelPaymentWithoutSca(spiContextData, payment, aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("Payment-ID [{}]. Proceed no SCA Cancellation failed. Can't Cancel Payment without SCA at SPI level. Error msg: {}.", (Object)encryptedPaymentId, (Object)errorHolder);
            return ResponseObject.builder().fail(errorHolder).build();
        }
        this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, TransactionStatus.CANC);
        this.updatePaymentStatusAfterSpiService.updateInternalPaymentStatus(encryptedPaymentId, InternalPaymentStatus.CANCELLED_FINALISED);
        CancelPaymentResponse cancelPaymentResponse = new CancelPaymentResponse();
        cancelPaymentResponse.setTransactionStatus(TransactionStatus.CANC);
        cancelPaymentResponse.setInternalRequestId(this.requestProviderService.getInternalRequestIdString());
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    @ConstructorProperties(value={"paymentCancellationSpi", "updatePaymentStatusAfterSpiService", "cancellationScaNeededDecider", "spiContextDataProvider", "spiErrorMapper", "spiToXs2aCancelPaymentMapper", "authorisationMethodDecider", "paymentCancellationAuthorisationService", "requestProviderService", "aspspConsentDataProviderFactory"})
    public CancelPaymentService(PaymentCancellationSpi paymentCancellationSpi, Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService, PaymentCancellationAuthorisationNeededDecider cancellationScaNeededDecider, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper, AuthorisationMethodDecider authorisationMethodDecider, PaymentCancellationAuthorisationService paymentCancellationAuthorisationService, RequestProviderService requestProviderService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        this.paymentCancellationSpi = paymentCancellationSpi;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.cancellationScaNeededDecider = cancellationScaNeededDecider;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.spiToXs2aCancelPaymentMapper = spiToXs2aCancelPaymentMapper;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.paymentCancellationAuthorisationService = paymentCancellationAuthorisationService;
        this.requestProviderService = requestProviderService;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }
}

