/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.xs2a.domain.CustomContentTypeProvider;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import java.util.function.Function;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ResponseMapper {
    public <T, R> ResponseEntity ok(ResponseObject<T> response, Function<T, R> mapper) {
        return this.generateResponse(response, HttpStatus.OK, mapper);
    }

    public <T, R> ResponseEntity created(ResponseObject<T> response, Function<T, R> mapper) {
        return this.generateResponse(response, HttpStatus.CREATED, mapper);
    }

    public <T, R> ResponseEntity delete(ResponseObject<T> response, Function<T, R> mapper) {
        return this.generateResponse(response, HttpStatus.NO_CONTENT, mapper);
    }

    public <T, R> ResponseEntity ok(ResponseObject<T> response, Function<T, R> mapper, ResponseHeaders responseHeaders) {
        return this.generateResponse(response, HttpStatus.OK, mapper, responseHeaders);
    }

    public <T, R> ResponseEntity created(ResponseObject<T> response, Function<T, R> mapper, ResponseHeaders responseHeaders) {
        return this.generateResponse(response, HttpStatus.CREATED, mapper, responseHeaders);
    }

    public <T> ResponseEntity created(ResponseObject<T> response, ResponseHeaders responseHeaders) {
        return this.generateResponse(response, HttpStatus.CREATED, null, responseHeaders);
    }

    public <T> ResponseEntity ok(ResponseObject<T> response) {
        return this.generateResponse(response, HttpStatus.OK);
    }

    public <T> ResponseEntity created(ResponseObject<T> response) {
        return this.generateResponse(response, HttpStatus.CREATED);
    }

    public <T> ResponseEntity delete(ResponseObject<T> response) {
        return this.generateResponse(response, HttpStatus.NO_CONTENT);
    }

    public <T> ResponseEntity accepted(ResponseObject<T> response) {
        return this.generateResponse(response, HttpStatus.ACCEPTED);
    }

    private <T> ResponseEntity generateResponse(ResponseObject<T> response, HttpStatus positiveStatus) {
        return this.generateResponse(response, positiveStatus, null);
    }

    private <T, R> ResponseEntity generateResponse(ResponseObject<T> response, HttpStatus positiveStatus, Function<T, R> mapper) {
        ResponseHeaders emptyHeaders = ResponseHeaders.builder().build();
        return this.generateResponse(response, positiveStatus, mapper, emptyHeaders);
    }

    private <T, R> ResponseEntity generateResponse(ResponseObject<T> response, HttpStatus positiveStatus, Function<T, R> mapper, ResponseHeaders responseHeaders) {
        if (response.hasError()) {
            throw new IllegalArgumentException("Response includes an error: " + response.getError());
        }
        T body = response.getBody();
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.status((HttpStatus)positiveStatus);
        if (body instanceof CustomContentTypeProvider) {
            responseBuilder = responseBuilder.contentType(((CustomContentTypeProvider)body).getCustomContentType());
        }
        return ((ResponseEntity.BodyBuilder)responseBuilder.headers(responseHeaders.getHttpHeaders())).body(this.getBody(body, mapper));
    }

    private <T, R> Object getBody(T body, Function<T, R> mapper) {
        return mapper == null ? body : mapper.apply(body);
    }
}

