/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ConsentPsuDataMapper {
    public UpdateConsentPsuDataReq mapToUpdateConsentPsuDataReq(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        return Optional.ofNullable(response).map(data -> {
            UpdateConsentPsuDataReq req = new UpdateConsentPsuDataReq();
            req.setPsuData(response.getPsuData());
            req.setConsentId(request.getBusinessObjectId());
            req.setAuthorizationId(request.getAuthorisationId());
            req.setAuthenticationMethodId(Optional.ofNullable(data.getChosenScaMethod()).map(AuthenticationObject::getAuthenticationMethodId).orElse(null));
            req.setScaAuthenticationData(request.getScaAuthenticationData());
            req.setScaStatus(data.getScaStatus());
            req.setAuthorisationType(AuthorisationType.CONSENT);
            return req;
        }).orElse(null);
    }
}

