/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.aspsp.profile.domain.MulticurrencyAccountLevel;
import de.adorsys.psd2.model.AccountDetails;
import de.adorsys.psd2.model.AccountList;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.InlineResponse200;
import de.adorsys.psd2.model.ReadAccountBalanceResponse200;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ReportExchangeMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.mapper.BalanceMapper;
import de.adorsys.psd2.xs2a.web.mapper.DayOfExecutionMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import java.util.Arrays;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={AmountModelMapper.class, PurposeCodeMapper.class, Xs2aAddressMapper.class, AspspProfileServiceWrapper.class, ReportExchangeMapper.class, BalanceMapper.class, DayOfExecutionMapper.class})
public abstract class AccountModelMapper {
    private static final List<MulticurrencyAccountLevel> MULTICURRENCY_ACCOUNT_AGGREGATION_LEVELS = Arrays.asList(MulticurrencyAccountLevel.AGGREGATION, MulticurrencyAccountLevel.AGGREGATION_AND_SUBACCOUNT);
    @Autowired
    protected HrefLinkMapper hrefLinkMapper;
    @Autowired
    protected AspspProfileServiceWrapper aspspProfileServiceWrapper;
    @Autowired
    protected BalanceMapper balanceMapper;

    @Mapping(target="currency", source="currency.currencyCode")
    public abstract AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference var1);

    public abstract List<AccountReference> mapToAccountReferences(List<de.adorsys.psd2.xs2a.core.profile.AccountReference> var1);

    public AccountList mapToAccountList(Xs2aAccountListHolder xs2aAccountListHolder) {
        List<Xs2aAccountDetails> accountDetailsList = xs2aAccountListHolder.getAccountDetails();
        List details = accountDetailsList.stream().map(this::mapToAccountDetails).collect(Collectors.toList());
        return new AccountList().accounts(details);
    }

    public InlineResponse200 mapToInlineResponse200(Xs2aAccountDetailsHolder xs2aAccountDetailsHolder) {
        InlineResponse200 inlineResponse200 = new InlineResponse200();
        inlineResponse200.setAccount(this.mapToAccountDetails(xs2aAccountDetailsHolder.getAccountDetails()));
        return inlineResponse200;
    }

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()))"), @Mapping(target="status", source="accountStatus"), @Mapping(target="usage", source="usageType"), @Mapping(target="currency", expression="java(mapToAccountDetailsCurrency(accountDetails.getCurrency()))")})
    public abstract AccountDetails mapToAccountDetails(Xs2aAccountDetails var1);

    @Mapping(target="account", source="xs2aAccountReference")
    public abstract ReadAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport var1);

    protected String mapToAccountDetailsCurrency(Currency currency) {
        return Optional.ofNullable(currency).map(Currency::getCurrencyCode).orElseGet(this::getMulticurrencyRepresentationOrNull);
    }

    private String getMulticurrencyRepresentationOrNull() {
        return MULTICURRENCY_ACCOUNT_AGGREGATION_LEVELS.contains(this.aspspProfileServiceWrapper.getMulticurrencyAccountLevel()) ? "XXX" : null;
    }
}

